% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfReadDataFile.R
\name{DfReadDataFile}
\alias{DfReadDataFile}
\title{Read a data file}
\usage{
DfReadDataFile(
  fileName,
  format = "JAFROC",
  newExcelFileFormat = FALSE,
  delimiter = ",",
  sequentialNames = FALSE
)
}
\arguments{
\item{fileName}{A string specifying the name of the file. 
The file-extension must match the format specified below}

\item{format}{A string specifying the format of the data in the file. 
It can be \code{"JAFROC"} (the default), \code{"MRMC"} or \code{"iMRMC"}. 
For \code{"MRMC"} the format is determined by the data file extension 
as specified in \url{http://perception.radiology.uiowa.edu/}, i.e.,  
\code{.csv} or \code{.txt} or \code{.lrc}. For file extension 
\code{.imrmc} the format is described in \url{https://code.google.com/p/imrmc/}.}

\item{newExcelFileFormat}{This argument only applies to the \code{"JAFROC"} format. 
The default is \code{FALSE}. if \code{TRUE} the function accommodates 3 
additional columns
in the \code{Truth} worksheet. If \code{FALSE}, the original function, as in version 
1.2.0 is used, and the three extra columns, if present, throws an error.}

\item{delimiter}{The string delimiter to be used for the \code{"MRMC"} 
format ("," is the default), see \url{http://perception.radiology.uiowa.edu/}.
This parameter is not used when reading \code{"JAFROC"} 
or \code{"iMRMC"} data files.}

\item{sequentialNames}{A logical variable: if \code{TRUE}, consecutive integers 
(starting from 1) will be used as the 
treatment and reader IDs (i.e., names). Otherwise, treatment 
and reader IDs in the original data file will be used.}
}
\value{
A dataset with the structure specified in \code{\link{RJafroc-package}}.
}
\description{
Read a disk file and create a dataset object from it.
}
\examples{
fileName <- system.file("extdata", "toyFiles/ROC/rocCr.xlsx", 
package = "RJafroc", mustWork = TRUE)
x <- DfReadDataFile(fileName, newExcelFileFormat = TRUE)

{
fileName <- system.file("extdata", "toyFiles/FROC/frocCr.xlsx", 
package = "RJafroc", mustWork = TRUE)
x <- DfReadDataFile(fileName, newExcelFileFormat = TRUE)
}

\donttest{
fileName <- system.file("extdata", "RocData.xlsx", 
package = "RJafroc", mustWork = TRUE)
RocDataXlsx <- DfReadDataFile(fileName)

fileName <- system.file("extdata", "RocData.csv", 
package = "RJafroc", mustWork = TRUE)
RocDataCsv<- DfReadDataFile(fileName, format = "MRMC")

fileName <- system.file("extdata", "RocData.imrmc", 
package = "RJafroc", mustWork = TRUE)
RocDataImrmc<- DfReadDataFile(fileName, format = "iMRMC")

fileName <- system.file("extdata", "FrocData.xlsx", 
package = "RJafroc", mustWork = TRUE)
FrocDataXlsx <- DfReadDataFile(fileName, sequentialNames = TRUE)
}

}
