% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset04}
\alias{dataset04}
\title{Federica Zanca FROC dataset}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1:5, 1:4, 1:200, 1:7], of non-lesion localizations, NLs}
\item{\code{LL}}{ Ratings array [1:5, 1:4, 1:100, 1:3], of lesion localizations, LLs}
\item{\code{lesionNum}}{ array [1:100], number of lesions per diseased case}
\item{\code{lesionID}}{ array [1:100, 1:3], labels of lesions on diseased cases, all set to 1}
\item{\code{lesionWeight}}{ array [1:100, 1:3] weights (or clinical importance) of lesions, all set to 1}
\item{\code{dataType}}{ "FROC", the data type}
\item{\code{modalityID}}{ [1:5] "1" "2" ... treatment labels}
\item{\code{readerID}}{ [1:4] "1" "3" "4" "5" reader labels}
}}
\usage{
dataset04
}
\description{
This is referred to in the book as the "FED" dataset. It consists of 200 mammograms, 
100 of which contained one to 3 simulated microcalcifications,
interpreted in five treatments (basically different image processing algorithms), by four 
radiologists using the FROC paradigm. The maximum number of NLs per case, over the entire 
dataset was 7 and the dataset contained at least one diseased mammogram with 3 lesions.
}
\examples{
str(dataset04)
PlotEmpiricalOperatingCharacteristics(dataset = dataset04, opChType = "wAFROC")$Plot


}
\references{
Zanca F et al. Evaluation of clinical image processing algorithms used 
in digital mammography. Medical Physics. 2009;36(3):765-775.
}
\keyword{datasets}
