% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset08}
\alias{dataset08}
\title{Monica Penedo ROC dataset}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1:5, 1:5, 1:112, 1], of false positives, FPs}
\item{\code{LL}}{ Ratings array [1:5, 1:5, 1:64, 1], of true positives, TPs}
\item{\code{lesionNum}}{ array [1:64], number of lesions per diseased case, all set to 1}
\item{\code{lesionID}}{ array [1:64, 1], labels of lesions on diseased cases, all set to 1}
\item{\code{lesionWeight}}{ array [1:64, 1], weights (or clinical importance) of lesions, all set to 1}
\item{\code{dataType}}{ "ROC", the data type}
\item{\code{modalityID}}{ [1:5] "0" "1", treatment labels}
\item{\code{readerID}}{ [1:5] "0" "1" "2" ..., reader labels}
}}
\usage{
dataset08
}
\description{
This is referred to in the book as the "PEN" dataset. It consists of 112 cases, 
64 of which are diseased, interpreted in five treatments (basically different image compression
algorithms) by five 
radiologists using the FROC paradigm (the inferred ROC dataset is included; the original FROC data
is lost).
}
\examples{
str(dataset08)
PlotEmpiricalOperatingCharacteristics(dataset = dataset08)$Plot


}
\references{
Penedo et al. Free-Response Receiver Operating Characteristic 
Evaluation of Lossy JPEG2000 and Object-based Set Partitioning in 
Hierarchical Trees Compression of Digitized Mammograms. 
Radiology. 2005;237(2):450-457.
}
\keyword{datasets}
