% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{binnedData125}
\alias{binnedData125}
\title{Binned dataset suitable for checking \link{FitCorCbm}; seed = 125}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1, 1:2, 1:10000, 1], of non-lesion localizations, NLs}
\item{\code{LL}}{ Ratings array [1, 1:2, 1:5000, 1], of lesion localizations, LLs}
\item{\code{lesionNum}}{ array [1:5000], number of lesions per diseased case, all set to one}
\item{\code{lesionID}}{ array [1:5000, 1], lesions labels on diseased cases, all set to one}
\item{\code{lesionWeight}}{ array [1:5000, 1], weights, all set to one}
\item{\code{dataType}}{ "ROC", the data type}
\item{\code{modalityID}}{ "1", treatment label}
\item{\code{readerID}}{ [1:2] "1" "2",  reader labels}
}}
\usage{
binnedData125
}
\description{
A binned dataset suitable for analysis by \link{FitCorCbm}. It was generated by
   \link{DfCreateCorCbmDataset} by setting the \code{seed} variable to 125. 
   Otherwise similar to \link{binnedData123}.
}
\examples{
str(binnedData125)

}
\references{
Zhai X, Chakraborty DP (2017). A bivariate contaminated binormal model for robust 
   fitting of proper ROC curves to a pair of correlated, possibly degenerate, 
   ROC datasets. Medical Physics. 44(6):2207--2222.
}
\keyword{datasets}
