% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilFigureOfMerit.R
\name{UtilFigureOfMerit}
\alias{UtilFigureOfMerit}
\title{Calculate empirical figures of merit (FOMs) for specified dataset}
\usage{
UtilFigureOfMerit(dataset, FOM = "wAFROC", FPFValue = 0.2)
}
\arguments{
\item{dataset}{The dataset to be analyzed, see \link{RJafroc-package}}

\item{FOM}{The figure of merit to be used in the calculation. 
The default is \code{"wAFROC"}}

\item{FPFValue}{Only needed for LROC data; where to evaluate a partial 
curve based figure of merit. The default is 0.2.}
}
\value{
An \code{c(I, J)} array, where the row names are the IDs of the 
   treatments and column names are the IDs of the readers.
}
\description{
Calculate the specified empirical figure of merit
for each treatment-reader combination in the ROC, FROC or LROC dataset
}
\details{
The allowed FOMs depend on the type of dataset (i.e., \code{dataType} 
   field of dataset object). 
   For \strong{ROC datasets:} the \code{"Wilcoxon"} is allowed.
   For \strong{FROC datasets:} The following FOMs are allowed:
   \code{"AFROC1"}, 
   \code{"AFROC"}, 
   \code{"wAFROC1"}, 
   \code{"wAFROC"} (the default), 
   \code{"HrAuc"}, 
   \code{"SongA1"}, 
   \code{"SongA2"},  
   \code{"HrSe"}, 
   \code{"HrSp"}, 
   \code{"MaxLLF"}, 
   \code{"MaxNLF"}, 
   \code{"MaxNLFAllCases"}, and 
   \code{"ExpTrnsfmSp"}. 
   The \code{"MaxLLF"}, \code{"MaxNLF"} and \code{"MaxNLFAllCases"} FOMs 
   correspond to ordinate, and abscissa, respectively, of the highest point 
   on the FROC operating characteristic obtained by counting all the marks). 
   The \code{"ExpTrnsfmSp"} FOM is described in the paper by Popescu. 
   Given the large number of FOMs possible with FROC data, it is appropriate 
   to make a recommendation: \strong{it is recommended that one use the wAFROC FOM.}
   For \strong{LROC datasets:} The following FOMs are allowed:\code{"Wilcoxon"} for 
   ROC data inferred from LROC data, which ignores localization information; 
   or \code{"PCL"} or \code{"ALROC"}, in which case one needs to specify an 
   additional argument, \code{FPFValue}: the desired FPF at which to evaluate 
   PCL or ALROC; the default is 0.2.
}
\examples{
# ROC data
UtilFigureOfMerit(dataset = dataset02, FOM = "Wilcoxon") 
# FROC dataset, converted to ROC, Wilcoxon FOM
UtilFigureOfMerit(DfFroc2Roc(dataset01), FOM = "Wilcoxon") 
# FROC dataset, default wAFROC FOM
UtilFigureOfMerit(dataset = dataset01) 
#LROC data
UtilFigureOfMerit(dataset = datasetCadLroc, FOM = "ALROC", FPFValue = 0.2) 

}
\references{
Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL. 
\url{https://www.crcpress.com/Observer-Performance-Methods-for-Diagnostic-Imaging-Foundations-Modeling/Chakraborty/p/book/9781482214840}

Chakraborty DP, Berbaum KS (2004) Observer studies involving detection and localization: modeling, analysis, and validation, 
Medical Physics, 31(8), 1--18.

Song T, Bandos AI, Rockette HE, Gur D (2008) On comparing methods for discriminating between actually negative and actually positive subjects 
with FROC type data, Medical Physics 35 1547--1558.

Popescu LM (2011) Nonparametric signal detectability evaluation using an exponential transformation of the FROC curve, 
Medical Physics, 38(10), 5690. 

Obuchowski NA, Lieber ML, Powell KA (2000) Data Analysis for Detection and Localization of Multiple Abnormalities 
with Application to Mammography, Acad Radiol, 7:7 553--554.

Swensson RG (1996) Unified measurement of observer performance in detecting and localizing target objects on images, 
Med Phys 23:10, 1709--1725.
}
