% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StSignificanceTestingCadVsRadiologists.R
\name{StSignificanceTestingCadVsRadiologists}
\alias{StSignificanceTestingCadVsRadiologists}
\title{Significance testing, CAD vs. radiologists}
\usage{
StSignificanceTestingCadVsRadiologists (dataset, FOM = "Wilcoxon", 
   option = "RRRC", method = "singleModality", FPFValue = 0.2)
}
\arguments{
\item{dataset}{\strong{The dataset must be ROC or LROC.}}

\item{FOM}{The desired FOM, default is \code{"Wilcoxon"} for ROC data, or ROC data 
inferred from LROC data; 
for LROC data the choices are \code{"PCL"} and \code{"ALROC"}.}

\item{option}{The desired generalization, the default is \code{"RRRC"}; 
another possibility is \code{"RRFC"}.}

\item{method}{\code{"singleModality"}, the default, or \code{"dualModality"},
see details.}

\item{FPFValue}{Only needed for LROC data; where to evaluate a partial curve based
   figure of merit, see details. The default is 0.2.

## potential project for summer student}
}
\value{
If \code{method = "singleModality"} the return value is a 
list with the following elements:

\item{fomCAD}{The observed FOM for CAD}

\item{fomRAD}{The observed FOM array for the readers}

\item{avgRadFom}{The average FOM of the readers}

\item{avgDiffFom}{The mean of the difference FOM, RAD - CAD}

\item{ciAvgDiffFom}{The 95-percent CI of the average difference, RAD - CAD}

\item{varR}{The variance of the radiologists}

\item{varError}{The variance of the error term in the single-treatment 
   multiple-reader OR model}

\item{cov2}{The covariance of the error term}

\item{tstat}{The observed value of the t-statistic; it's square is 
   equivalent to an F-statistic}

\item{df}{The degrees of freedom of the t-statistic}

\item{pval}{The p-value for rejecting the NH}

\item{Plots}{Empirical operating characteristic plots 
   corresponding to specified FOM}

If \code{method = "dualModality"} the return value is a list 
   with the following elements:

\item{fomCAD}{The observed FOM for CAD}

\item{fomRAD}{The observed FOM array for the readers}

\item{avgRadFom}{The average FOM of the readers}

\item{avgDiffFom}{The mean of the difference FOM, RAD - CAD}

\item{ciDiffFom}{A data frame containing the statistics associated 
   with the average difference, RAD - CAD}

\item{ciAvgRdrEachTrt}{A data frame containing the statistics 
   associated with the average FOM in each treatment}

\item{varR}{The variance of the pure reader term in the OR model}

\item{varTR}{The variance of the treatment-reader term error 
   term in the OR model}

\item{cov1}{The covariance1 of the error term - same reader, 
   different treatments}

\item{cov2}{The covariance2 of the error term  - 
   different readers, same treatment}

\item{cov3}{The covariance3 of the error term  - different readers, 
   different treatments}

\item{varError}{The variance of the pure error term in the OR model}

\item{Fstat}{The observed value of the F-statistic}

\item{ndf}{The numerator degrees of freedom of the F-statistic}

\item{ddf}{The denominator degrees of freedom of the F-statistic}

\item{pval}{The p-value for rejecting the NH}

\item{Plots}{Empirical operating characteristic plots corresponding 
   to specified FOM, i.e., if \code{FOM} = \code{"Wilcoxon"} an ROC plot
   is produced where reader 1 is CAD. If an LROC FOM is selected, an LROC
   plot is displayed.}
}
\description{
Significance testing, comparing CAD vs. a group of radiologists 
   interpreting the same cases, an example of single treatment analysis
}
\details{
PCL is the probability of a correct localization. The LROC is the plot of PCL 
   (ordinate) vs. FPF. For LROC data \code{"PCL"} means interpolated PCL value 
   at specified \code{"FPFValue"}. \code{"ALROC"} is the trapezoidal area 
   under the LROC
   from FPF = 0 to FPF = \code{FPFValue}. If \code{method = "singleModality"} 
   the first \strong{reader} is assumed to be CAD. If 
   \code{method = "dualModality"} the first \strong{treatment} is assumed to be CAD. 
   The NH is that the FOM of CAD equals the average of the readers. The 
   \code{method = "singleModality"} analysis uses an adaptation of the 
   single-treatment multiple-reader Obuchowski Rockette (OR) model described in a 
   paper by Hillis (2007), section 5.3. The adaptation is characterized by 3 
   parameters
   \code{VarR}, \code{Var} and \code{Cov2}, which are returned by the function. 
   The \code{method = "dualModality"} analysis replicates CAD data as many times as
   necessary so as to form one "treatment" of an MRMC pairing, the other 
   "treatment" being the 
   radiologists. Standard RRRC DBMH/ORH analysis is applied. The 
   method, described 
   in Kooi et al gives exactly the same final results (F-statistic, ddf and p-value) 
   as \code{"singleModality"} but the intermediate quantities are questionable. 
   The method is characterized by 6 OR parameters \code{VarR}, \code{VarTR}, 
   \code{Var}, \code{Cov1}, \code{Cov2} and \code{Cov3}, which are returned 
   by the function.
}
\note{
The extension of the code to FROC will be addressed in a future update.
}
\examples{
ret1M <- StSignificanceTestingCadVsRadiologists (dataset09, 
FOM = "Wilcoxon", method = "singleModality")

\dontrun{
ret2M <- StSignificanceTestingCadVsRadiologists (dataset09, 
FOM = "Wilcoxon", method = "dualModality")

retLroc1M <- StSignificanceTestingCadVsRadiologists (datasetCadLroc, 
FOM = "PCL", option = "RRRC", method = "singleModality", FPFValue = 0.05)

retLroc2M <- StSignificanceTestingCadVsRadiologists (datasetCadLroc, 
FOM = "PCL", option = "RRRC", method = "dualModality", FPFValue = 0.05)

## test with fewer readers
dataset09a <- DfExtractDataset(dataset09, rdrs = seq(1:7))
ret1M7 <- StSignificanceTestingCadVsRadiologists (dataset09a, 
FOM = "Wilcoxon", method = "singleModality")
ret2M7 <- StSignificanceTestingCadVsRadiologists (dataset09a, 
FOM = "Wilcoxon", method = "dualModality")

datasetCadLroc7 <- DfExtractDataset(datasetCadLroc, rdrs = seq(1:7))
ret1MLroc7 <- StSignificanceTestingCadVsRadiologists (datasetCadLroc7, 
FOM = "PCL", option = "RRRC", method = "singleModality", FPFValue = 0.05)

ret2MLroc7 <- StSignificanceTestingCadVsRadiologists (datasetCadLroc7, 
FOM = "PCL", option = "RRRC", method = "dualModality", FPFValue = 0.05)
}

}
\references{
Hillis SL (2007) A comparison of denominator degrees of freedom methods 
for multiple observer ROC studies, Statistics in Medicine. 26:596-619.

Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL. 
\url{https://www.crcpress.com/Observer-Performance-Methods-for-Diagnostic-Imaging-Foundations-Modeling/Chakraborty/p/book/9781482214840}

Hupse R, Samulski M, Lobbes M, et al (2013) Standalone computer-aided detection compared to radiologists 
performance for the detection of mammographic masses, Eur Radiol. 23(1):93-100.

Kooi T, Gubern-Merida A, et al. (2016) A comparison between a deep convolutional 
neural network and radiologists for classifying regions of interest in mammography. 
Paper presented at: International Workshop on Digital Mammography, Malmo, Sweden.
}
