% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfReadDataFile.R
\name{DfReadDataFile}
\alias{DfReadDataFile}
\title{Read a data file}
\usage{
DfReadDataFile(fileName, format = "JAFROC", 
   delimiter = ",", renumber = FALSE)
}
\arguments{
\item{fileName}{A string specifying the name of the file. 
The file-extension must match the format specified below}

\item{format}{A string specifying the format of the data in the file. 
It can be \code{"JAFROC"} (the default), \code{"MRMC"} or \code{"iMRMC"}. 
For \code{"MRMC"} the format is determined by the data file extension 
as specified in \url{http://perception.radiology.uiowa.edu/}, i.e.,  
\code{.csv} or \code{.txt} or \code{.lrc}. For file extension 
\code{.imrmc} the format is described in \url{https://code.google.com/p/imrmc/}.}

\item{delimiter}{The string delimiter to be used for the \code{"MRMC"} 
format ("," is the default), see \url{http://perception.radiology.uiowa.edu/}.
This parameter is not used when reading \code{"JAFROC"} 
or \code{"iMRMC"} data files.}

\item{renumber}{A logical variable: if \code{TRUE}, consecutive integers 
(starting from 1) will be used as the 
treatment and reader IDs. Otherwise, treatment 
and reader IDs in the original data file will be used.}
}
\value{
A dataset with the structure specified in \link{RJafroc-package}.
}
\description{
Read a disk file and create a dataset object from it.
}
\examples{
\dontrun{
fileName <- system.file("extdata", "includedRocData.xlsx", 
package = "RJafroc", mustWork = TRUE)
RocDataXlsx <- DfReadDataFile(fileName)

fileName <- system.file("extdata", "includedRocData.csv", 
package = "RJafroc", mustWork = TRUE)
RocDataCsv<- DfReadDataFile(fileName, format = "MRMC")

fileName <- system.file("extdata", "includedRocData.imrmc", 
package = "RJafroc", mustWork = TRUE)
RocDataImrmc<- DfReadDataFile(fileName, format = "iMRMC")

fileName <- system.file("extdata", "includedFrocData.xlsx", 
package = "RJafroc", mustWork = TRUE)
FrocDataXlsx <- DfReadDataFile(fileName, renumber = TRUE)

}

}
