/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.api;

import it.bancaditalia.oss.sdmx.api.BaseObservation;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.Utils;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.logging.Logger;

public class PortableTimeSeries<T>
implements List<BaseObservation<? extends T>>,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATEDNAME_ATTR_NAME = "CONNECTORS_AUTONAME";
    protected static final Logger logger = Configuration.getSdmxLogger();
    private final Map<String, Map.Entry<String, String>> dimensions = new LinkedHashMap<String, Map.Entry<String, String>>();
    private final List<BaseObservation<? extends T>> observations = new ArrayList<BaseObservation<? extends T>>();
    private final Map<String, String> attributes = new HashMap<String, String>();
    private boolean errorFlag = false;
    private boolean numeric = true;
    private String errorMessage = null;
    private String name;
    private boolean useGeneratedName = true;
    private String frequency = null;
    private Dataflow dataflow = null;

    public PortableTimeSeries() {
    }

    public PortableTimeSeries(PortableTimeSeries<?> portableTimeSeries) {
        this.errorFlag = portableTimeSeries.errorFlag;
        this.numeric = portableTimeSeries.numeric;
        this.errorMessage = portableTimeSeries.errorMessage;
        this.name = portableTimeSeries.name;
        this.useGeneratedName = portableTimeSeries.useGeneratedName;
        this.frequency = portableTimeSeries.frequency;
        this.dataflow = portableTimeSeries.dataflow;
        this.attributes.putAll(portableTimeSeries.attributes);
        this.dimensions.putAll(portableTimeSeries.dimensions);
        this.name = portableTimeSeries.name;
    }

    public boolean matchesMetadata(PortableTimeSeries<?> portableTimeSeries) {
        return !this.errorFlag && portableTimeSeries != null && !portableTimeSeries.errorFlag && this.size() == portableTimeSeries.size() && this.frequency.equals(portableTimeSeries.frequency);
    }

    public Map<String, String> getAttributesMap() {
        if (!this.attributes.containsKey(GENERATEDNAME_ATTR_NAME) && this.dataflow != null && this.dataflow.getName() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.dataflow != null && this.dataflow.getName() != null && !this.dataflow.getName().isEmpty()) {
                stringBuilder.append(this.dataflow.getName());
            }
            for (Map.Entry<String, String> entry : this.dimensions.values()) {
                stringBuilder.append(", " + entry.getKey() + "(" + (entry.getValue() != null ? entry.getValue() : "") + ")");
            }
            this.attributes.put(GENERATEDNAME_ATTR_NAME, stringBuilder.toString());
        }
        return this.attributes;
    }

    public <R> PortableTimeSeries<R> mapValues(Utils.Function<T, R> function) {
        PortableTimeSeries<R> portableTimeSeries = new PortableTimeSeries<R>(this);
        for (BaseObservation<T> baseObservation : this) {
            portableTimeSeries.add(baseObservation.mapValue(function));
        }
        return portableTimeSeries;
    }

    public <U, R> PortableTimeSeries<R> combineValues(PortableTimeSeries<U> portableTimeSeries, Utils.BiFunction<T, U, R> biFunction) {
        if (this.size() != portableTimeSeries.size()) {
            throw new UnsupportedOperationException("The two series do not have the same size.");
        }
        PortableTimeSeries<R> portableTimeSeries2 = new PortableTimeSeries<R>(this);
        Iterator<BaseObservation<U>> iterator = portableTimeSeries.iterator();
        for (BaseObservation<T> baseObservation : this) {
            portableTimeSeries2.add(baseObservation.combine(iterator.next(), biFunction));
        }
        return portableTimeSeries2;
    }

    public String[] getAttributeNamesArray() {
        return this.getAttributesMap().keySet().toArray(new String[0]);
    }

    public String getAttribute(String string) {
        return this.getAttributesMap().get(string);
    }

    public void setAttributes(Map<String, String> map) {
        this.getAttributesMap().clear();
        this.getAttributesMap().putAll(map);
    }

    public void addAttribute(String string, String string2) {
        this.getAttributesMap().put(string, string2);
    }

    public Map<String, String> getDimensionsMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Map.Entry<String, String>> entry : this.dimensions.entrySet()) {
            linkedHashMap.put(entry.getKey(), Configuration.getCodesPolicy().equalsIgnoreCase("description") ? entry.getValue().getValue() : entry.getValue().getKey());
        }
        return linkedHashMap;
    }

    public String[] getDimensionNamesArray() {
        return this.dimensions.keySet().toArray(new String[0]);
    }

    public String getDimension(String string) {
        return this.dimensions.containsKey(string) ? this.dimensions.get(string).getKey() : null;
    }

    public void setDimensions(Map<String, Map.Entry<String, String>> map) {
        this.dimensions.clear();
        this.dimensions.putAll(map);
        this.attributes.remove(GENERATEDNAME_ATTR_NAME);
        if (this.useGeneratedName) {
            this.name = null;
        }
    }

    public void addDimension(String string, String string2) {
        this.dimensions.put(string, new AbstractMap.SimpleEntry<String, Object>(string2, null));
        this.attributes.remove(GENERATEDNAME_ATTR_NAME);
        if (this.useGeneratedName) {
            this.name = null;
        }
    }

    @Deprecated
    public List<T> getObservations() {
        return new ListWrapper(Utils.obsExtractor());
    }

    @Deprecated
    public Object[] getObservationsArray() {
        if (this.isNumeric()) {
            return this.getObservations().toArray(new Double[0]);
        }
        return this.getObservations().toArray(new String[0]);
    }

    @Deprecated
    public List<String> getTimeSlots() {
        return new ListWrapper<String>(Utils.timeslotExtractor());
    }

    @Deprecated
    public String[] getTimeSlotsArray() {
        return this.getTimeSlots().toArray(new String[0]);
    }

    public Set<String> getObsLevelAttributesNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (BaseObservation<T> baseObservation : this) {
            hashSet.addAll(baseObservation.getAttributes().keySet());
        }
        return hashSet;
    }

    public String[] getObsLevelAttributesNamesArray() {
        return this.getObsLevelAttributesNames().toArray(new String[0]);
    }

    public List<String> getObsLevelAttributes(String string) {
        return new ListWrapper<String>(Utils.obsLevelAttrsExtractor(string));
    }

    public String[] getObsLevelAttributesArray(String string) {
        return this.getObsLevelAttributes(string).toArray(new String[0]);
    }

    public String getName() {
        if (this.useGeneratedName && this.name == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.dataflow != null && this.dataflow.getId() != null && !this.dataflow.getId().isEmpty()) {
                stringBuilder.append(this.dataflow.getId() + ".");
            }
            for (Map.Entry<String, String> entry : this.dimensions.values()) {
                stringBuilder.append((Configuration.getCodesPolicy().equalsIgnoreCase("description") ? entry.getValue() : entry.getKey()) + ".");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            this.name = stringBuilder.toString();
        }
        return this.name;
    }

    public void setName(String string) {
        this.useGeneratedName = false;
        this.name = string;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String string) {
        this.frequency = string;
    }

    public String getDataflow() {
        return this.dataflow.getId();
    }

    public Dataflow getDataflowObject() {
        return this.dataflow;
    }

    public void setDataflow(Dataflow dataflow) {
        this.dataflow = dataflow;
    }

    public boolean isErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(boolean bl) {
        this.errorFlag = bl;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void reverse() {
        Collections.reverse(this);
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setNumeric(boolean bl) {
        this.numeric = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(50000);
        stringBuilder.append("\nName: " + this.getName());
        stringBuilder.append("\nFrequency: " + this.frequency);
        stringBuilder.append("\nnumeric: " + this.isNumeric());
        stringBuilder.append("\nerror: " + this.isErrorFlag());
        stringBuilder.append("\nerror_msg: " + this.getErrorMessage());
        stringBuilder.append("\nAttributes: " + this.getAttributesMap());
        stringBuilder.append("\nDimensions: " + this.getDimensionsMap());
        stringBuilder.append("\nVALUES: ");
        stringBuilder.append(this.getObservations());
        stringBuilder.append("\nTIMES:");
        stringBuilder.append(this.getTimeSlots());
        stringBuilder.append("\nOBSERVATION ATTRIBUTES:");
        stringBuilder.append("{");
        boolean bl = true;
        for (String string : this.getObsLevelAttributesNames()) {
            stringBuilder.append((bl ? "" : ", ") + string + "=");
            stringBuilder.append(this.getObsLevelAttributes(string));
            bl = false;
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public List<String> getAttributes() {
        return Arrays.asList(this.getAttributesArray());
    }

    @Deprecated
    public String getAttributeValue(String string) {
        return this.getAttribute(string);
    }

    @Deprecated
    public String[] getAttributesArray() {
        String[] stringArray = new String[this.getAttributesMap().size()];
        int n = 0;
        for (Map.Entry<String, String> entry : this.getAttributesMap().entrySet()) {
            stringArray[n++] = entry.getKey() + "=" + entry.getValue();
        }
        return stringArray;
    }

    @Deprecated
    public void setAttributes(List<String> list) {
        this.getAttributesMap().clear();
        for (String string : list) {
            this.getAttributesMap().put(string.split("=")[0], string.split("=")[1]);
        }
    }

    @Deprecated
    public void addAttribute(String string) {
        this.addAttribute(string.split("=")[0], string.split("=")[1]);
    }

    @Deprecated
    public List<String> getDimensions() {
        return Arrays.asList(this.getDimensionsArray());
    }

    @Deprecated
    public String getDimensionValue(String string) {
        return this.getDimension(string);
    }

    @Deprecated
    public String[] getDimensionsArray() {
        String[] stringArray = new String[this.dimensions.size()];
        int n = 0;
        for (Map.Entry<String, Map.Entry<String, String>> entry : this.dimensions.entrySet()) {
            stringArray[n++] = entry.getKey() + "=" + entry.getValue().getKey();
        }
        return stringArray;
    }

    @Deprecated
    public void addDimension(String string) {
        this.addDimension(string.split("=")[0], string.split("=")[1]);
    }

    @Deprecated
    public List<String> getStatus() {
        return this.getObsLevelAttributes("OBS_STATUS");
    }

    @Deprecated
    public String[] getStatusArray() {
        return this.getStatus().toArray(new String[0]);
    }

    @Override
    public boolean add(BaseObservation<? extends T> baseObservation) {
        return this.observations.add(baseObservation);
    }

    @Override
    public void add(int n, BaseObservation<? extends T> baseObservation) {
        this.observations.add(n, baseObservation);
    }

    @Override
    public boolean addAll(Collection<? extends BaseObservation<? extends T>> collection) {
        return this.observations.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends BaseObservation<? extends T>> collection) {
        return this.observations.addAll(n, collection);
    }

    @Override
    public void clear() {
        this.observations.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.observations.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.observations.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return this.observations.equals(object);
    }

    @Override
    public BaseObservation<? extends T> get(int n) {
        return this.observations.get(n);
    }

    @Override
    public int hashCode() {
        return this.observations.hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.observations.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.observations.isEmpty();
    }

    @Override
    public Iterator<BaseObservation<? extends T>> iterator() {
        return this.observations.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.observations.lastIndexOf(object);
    }

    @Override
    public ListIterator<BaseObservation<? extends T>> listIterator() {
        return this.observations.listIterator();
    }

    @Override
    public ListIterator<BaseObservation<? extends T>> listIterator(int n) {
        return this.observations.listIterator(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.observations.remove(object);
    }

    @Override
    public BaseObservation<? extends T> remove(int n) {
        return this.observations.remove(n);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.observations.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.observations.retainAll(collection);
    }

    @Override
    public BaseObservation<? extends T> set(int n, BaseObservation<? extends T> baseObservation) {
        return this.observations.set(n, baseObservation);
    }

    @Override
    public int size() {
        return this.observations.size();
    }

    @Override
    public List<BaseObservation<? extends T>> subList(int n, int n2) {
        return this.observations.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.observations.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] T1Array) {
        return this.observations.toArray(T1Array);
    }

    private class ListWrapper<T1>
    extends AbstractList<T1> {
        final Utils.Function<BaseObservation<? extends T>, T1> func;

        public ListWrapper(Utils.Function<BaseObservation<? extends T>, T1> function) {
            this.func = function;
        }

        @Override
        public int size() {
            return PortableTimeSeries.this.size();
        }

        @Override
        public T1 get(int n) {
            return this.func.apply((BaseObservation<Object>)PortableTimeSeries.this.get(n));
        }
    }
}

