/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.api;

import it.bancaditalia.oss.sdmx.exceptions.DataStructureException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class PortableTimeSeries {
    protected static Logger logger = Configuration.getSdmxLogger();
    private String frequency = null;
    private String dataflow = null;
    private List<String> attributes = new ArrayList<String>();
    private List<String> dimensions = new ArrayList<String>();
    private List<String> timeSlots = new ArrayList<String>();
    private List<Double> observations = new ArrayList<Double>();
    private List<String> status = new ArrayList<String>();
    private Hashtable<String, ArrayList<String>> obsLevelAttributes = new Hashtable();
    private String name;

    public List<String> getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String string) {
        String string2 = null;
        for (String string3 : this.attributes) {
            String[] stringArray = string3.split("\\s*=\\s*");
            String string4 = stringArray[0];
            String string5 = stringArray[1];
            if (string4 == null || string4.isEmpty() || string5 == null || !string4.equals(string)) continue;
            string2 = string5;
            break;
        }
        return string2;
    }

    public String[] getAttributesArray() {
        return this.attributes.toArray(new String[0]);
    }

    public void setAttributes(List<String> list) {
        this.attributes = list;
    }

    public void addAttribute(String string) {
        this.attributes.add(string);
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public String getDimensionValue(String string) {
        String string2 = null;
        for (String string3 : this.dimensions) {
            String[] stringArray = string3.split("\\s*=\\s*");
            String string4 = stringArray[0];
            String string5 = stringArray[1];
            if (string4 == null || string4.isEmpty() || string5 == null || !string4.equals(string)) continue;
            string2 = string5;
            break;
        }
        return string2;
    }

    public String[] getDimensionsArray() {
        return this.dimensions.toArray(new String[0]);
    }

    public void setDimensions(List<String> list) {
        this.dimensions = list;
    }

    public void addDimension(String string) {
        this.dimensions.add(string);
    }

    public void addObservation(String string, String string2, Hashtable<String, String> hashtable) {
        if (string == null || string.isEmpty()) {
            logger.info(this.getName() + ": missing observation for time slot: " + string2 + ", I'll set a NaN.");
            this.observations.add(new Double("NaN"));
        } else {
            try {
                this.observations.add(new Double(string));
            }
            catch (NumberFormatException numberFormatException) {
                logger.info(this.getName() + ": found invalid observation for time slot: " + string2 + ", I'll set a NaN.");
                this.observations.add(new Double("NaN"));
            }
        }
        if (string2 == null || string2.isEmpty()) {
            logger.info(this.getName() + ": a time slot is missing. This is not a well formed time series. I'll set a blank character.");
            string2 = "";
        }
        this.timeSlots.add(string2);
        if (hashtable != null) {
            for (String object : hashtable.keySet()) {
                if (object.equals("OBS_STATUS")) {
                    this.status.add(hashtable.get(object));
                }
                if (this.obsLevelAttributes.containsKey(object)) {
                    this.obsLevelAttributes.get(object).add(hashtable.get(object));
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < this.timeSlots.size() - 1; ++i) {
                    arrayList.add("");
                }
                arrayList.add(hashtable.get(object));
                this.obsLevelAttributes.put(object, arrayList);
            }
        }
        if (this.obsLevelAttributes != null) {
            for (ArrayList arrayList : this.obsLevelAttributes.values()) {
                if (arrayList.size() >= this.timeSlots.size()) continue;
                arrayList.add("");
            }
        }
    }

    public void setObservations(List<Double> list) throws DataStructureException {
        if (list.size() != this.timeSlots.size()) {
            throw new DataStructureException("Error setting data in time series. Wrong observation number.");
        }
        this.observations = list;
    }

    public List<Double> getObservations() {
        return this.observations;
    }

    public Double[] getObservationsArray() {
        return this.observations.toArray(new Double[0]);
    }

    public void setTimeSlots(List<String> list) throws DataStructureException {
        if (list.size() != this.observations.size()) {
            throw new DataStructureException("Error setting dates in time series. Wrong dates number.");
        }
        this.timeSlots = list;
    }

    public List<String> getTimeSlots() {
        return this.timeSlots;
    }

    public String[] getTimeSlotsArray() {
        return this.timeSlots.toArray(new String[0]);
    }

    @Deprecated
    public List<String> getStatus() {
        return this.status;
    }

    @Deprecated
    public String[] getStatusArray() {
        return this.status.toArray(new String[0]);
    }

    public List<String> getObsLevelAttributesNames() {
        return Collections.list(this.obsLevelAttributes.keys());
    }

    public String[] getObsLevelAttributesNamesArray() {
        return this.getObsLevelAttributesNames().toArray(new String[0]);
    }

    public List<String> getObsLevelAttributes(String string) {
        return this.obsLevelAttributes.get(string);
    }

    public String[] getObsLevelAttributesArray(String string) {
        return this.getObsLevelAttributes(string).toArray(new String[0]);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        String string = this.name;
        if ((string == null || string.isEmpty()) && this.dimensions.size() > 0) {
            string = this.dataflow != null && !this.dataflow.isEmpty() ? this.dataflow + "." : "";
            String string2 = "[ =]";
            Iterator<String> iterator = this.dimensions.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                String[] stringArray = string3.split(string2);
                String string4 = stringArray[1];
                string = string + string4;
                if (!iterator.hasNext()) continue;
                string = string + ".";
            }
        }
        return string;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String string) {
        this.frequency = string;
    }

    public String getDataflow() {
        return this.dataflow;
    }

    public void setDataflow(String string) {
        this.dataflow = string;
    }

    public void reverse() {
        Collections.reverse(this.observations);
        Collections.reverse(this.timeSlots);
        for (String string : this.obsLevelAttributes.keySet()) {
            ArrayList<String> arrayList = this.obsLevelAttributes.get(string);
            Collections.reverse(arrayList);
            this.obsLevelAttributes.put(string, arrayList);
        }
    }

    public String toString() {
        String string = "";
        string = string + "\nName: " + this.getName();
        string = string + "\nFrequency: " + this.frequency;
        string = string + "\nAttributes: " + this.attributes;
        string = string + "\nDimensions: " + this.dimensions;
        string = string + "\nVALUES: ";
        string = string + this.observations;
        string = string + "\nTIMES:";
        string = string + this.timeSlots;
        string = string + "\nOBSERVATION ATTRIBUTES:";
        string = string + this.obsLevelAttributes;
        return string;
    }
}

