/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import it.bancaditalia.oss.sdmx.util.LoginDialog;
import it.bancaditalia.oss.sdmx.util.SdmxProxySelector;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class Configuration {
    protected static Logger SDMX_LOGGER = null;
    protected static final String PROXY_AUTH_KERBEROS = "Kerberos";
    protected static final String PROXY_AUTH_DIGEST = "digest";
    protected static final String PROXY_AUTH_BASIC = "basic";
    protected static final String JAVA_SECURITY_KERBEROS_PROP = "java.security.krb5.conf";
    protected static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG_PROP = "java.security.auth.login.config";
    protected static final String HTTP_AUTH_PREF_PROP = "http.auth.preference";
    protected static final String SSL_DISABLE_CERT_CHECK_PROP = "ssl.disable.cert.check";
    protected static final String SSL_TRUSTSTORE_PROP = "javax.net.ssl.trustStore";
    protected static final String CENTRAL_CONFIGURATION_FILE_PROP = "SDMX_CONF";
    protected static final String EXTERNAL_PROVIDERS_PROP = "external.providers";
    protected static final String PROXY_NAME_PROP = "http.proxy.name";
    protected static final String PROXY_DEFAULT_PROP = "http.proxy.default";
    protected static final String HTTP_AUTH_USER_PROP = "http.auth.user";
    protected static final String PROXY_AUTH_PW_PROP = "http.auth.pw";
    protected static final String REVERSE_DUMP_PROP = "reverse.dump";
    protected static final String SDMX_LANG_PROP = "sdmx.lang";
    protected static final String LATE_RESP_RETRIES_PROP = "late.response.retries";
    protected static final String TABLE_DUMP_PROP = "table.dump";
    protected static final String READ_TIMEOUT_PROP = "read.timeout";
    protected static final String CONNECT_TIMEOUT_PROP = "connect.timeout";
    private static final String REVERSE_DUMP_DEFAULT = "FALSE";
    private static final String TABLE_DUMP_DEFAULT = "FALSE";
    private static final String SDMX_DEFAULT_LANG = "en";
    private static final String SDMX_DEFAULT_TIMEOUT = "0";
    private static final String LOGGER_NAME = "SDMX";
    private static final String CONFIGURATION_FILE_NAME = "configuration.properties";
    private static String SDMX_LANG = "en";
    private static final String sourceClass = Configuration.class.getSimpleName();
    private static Properties props = new Properties();

    protected static void setSdmxLogger() {
        if (SDMX_LOGGER == null) {
            SDMX_LOGGER = Logger.getLogger(LOGGER_NAME);
            LogManager.getLogManager().addLogger(SDMX_LOGGER);
        }
    }

    public static Logger getSdmxLogger() {
        Configuration.setSdmxLogger();
        return SDMX_LOGGER;
    }

    public static Properties getConfiguration() {
        return props;
    }

    public static boolean isSSLCertificatesDisabled() {
        return props.getProperty(SSL_DISABLE_CERT_CHECK_PROP, "FALSE").equalsIgnoreCase("TRUE");
    }

    public static boolean isReverse() {
        return props.getProperty(REVERSE_DUMP_PROP, "FALSE").equalsIgnoreCase("TRUE");
    }

    public static boolean isTable() {
        return props.getProperty(TABLE_DUMP_PROP, "FALSE").equalsIgnoreCase("TRUE");
    }

    public static String getExternalProviders() {
        return props.getProperty(EXTERNAL_PROVIDERS_PROP);
    }

    public static int getReadTimeout(String string) {
        String string2 = props.getProperty(string + "." + READ_TIMEOUT_PROP, null);
        if (string2 == null) {
            string2 = props.getProperty(READ_TIMEOUT_PROP, SDMX_DEFAULT_TIMEOUT);
        }
        return Integer.parseInt(string2);
    }

    public static int getConnectTimeout(String string) {
        String string2 = props.getProperty(string + "." + CONNECT_TIMEOUT_PROP, null);
        if (string2 == null) {
            string2 = props.getProperty(CONNECT_TIMEOUT_PROP, SDMX_DEFAULT_TIMEOUT);
        }
        return Integer.parseInt(string2);
    }

    public static String getLang() {
        return SDMX_LANG;
    }

    public static String getLateResponseRetries(int n) {
        return props.getProperty(LATE_RESP_RETRIES_PROP, Integer.toString(n));
    }

    public static void setLang(String string) {
        SDMX_LANG = string;
    }

    public static void init() {
        Object object;
        Object object2;
        Object object3;
        Configuration.setSdmxLogger();
        System.setProperty("http.agent", LOGGER_NAME);
        Object object4 = null;
        try {
            object3 = Class.forName("it.bancaditalia.oss.sdmx.util.SdmxConfiguration");
            object2 = ((Class)object3).getMethod("init", new Class[0]);
            ((Method)object2).invoke((Object)null, new Object[0]);
            object4 = ((Class)object3).getCanonicalName();
            SDMX_LOGGER.info("Reading " + (String)object4 + " configuration.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = null;
        object2 = null;
        if (new File(CONFIGURATION_FILE_NAME).exists()) {
            try {
                object3 = new FileInputStream(CONFIGURATION_FILE_NAME);
                object2 = new FileInputStream(CONFIGURATION_FILE_NAME);
                Configuration.init((InputStream)object3, (InputStream)object2);
                object4 = System.getProperty("user.dir") + File.separator + CONFIGURATION_FILE_NAME;
                SDMX_LOGGER.info("Configuration file: " + (String)object4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            object = System.getenv(CENTRAL_CONFIGURATION_FILE_PROP);
            if (object != null && !((String)object).isEmpty() && new File((String)object).exists()) {
                try {
                    object3 = new FileInputStream((String)object);
                    object2 = new FileInputStream((String)object);
                    Configuration.init((InputStream)object3, (InputStream)object2);
                    object4 = object;
                    SDMX_LOGGER.info("Configuration file: " + (String)object4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (object4 == null) {
            object = new ConsoleHandler();
            ((Handler)object).setLevel(Level.INFO);
            SDMX_LOGGER.addHandler((Handler)object);
            object4 = "default";
            SDMX_LOGGER.info("No configuration found. Apply defaults.");
        }
    }

    public static void init(InputStream inputStream, InputStream inputStream2) throws SecurityException, IOException {
        Configuration.setSdmxLogger();
        LogManager.getLogManager().readConfiguration(inputStream);
        inputStream.close();
        props.load(inputStream2);
        inputStream2.close();
        String string = props.getProperty(SSL_TRUSTSTORE_PROP);
        if (string != null && !string.isEmpty()) {
            System.setProperty(SSL_TRUSTSTORE_PROP, string);
        }
        SDMX_LANG = props.getProperty(SDMX_LANG_PROP, SDMX_DEFAULT_LANG);
        Configuration.configureProxy(props);
    }

    private static void configureProxy(Properties properties) {
        String string;
        Object object;
        String string2;
        String[] stringArray;
        Logger logger = SDMX_LOGGER;
        logger.entering(sourceClass, "configureProxy");
        String string3 = properties.getProperty(PROXY_DEFAULT_PROP);
        String string4 = null;
        int n = 0;
        boolean bl = false;
        if (string3 != null && !string3.isEmpty()) {
            bl = true;
            stringArray = string3.split(":");
            if (stringArray.length != 2 || stringArray[0] == null || stringArray[0].isEmpty() || stringArray[1] == null || stringArray[1].isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. found: '" + string3 + "'");
            }
            string4 = stringArray[0].trim();
            n = Integer.parseInt(stringArray[1].trim());
        }
        stringArray = new SdmxProxySelector(string4, n);
        int n2 = 0;
        while ((string2 = properties.getProperty(PROXY_NAME_PROP + n2)) != null && !string2.isEmpty()) {
            bl = true;
            object = null;
            object = string2.split(":");
            if (object == null || ((String[])object).length != 2 || object[0] == null || object[0].isEmpty() || object[1] == null || object[1].isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. host: '" + object[0] + "', port: '" + object[1] + "'");
            }
            string = properties.getProperty(PROXY_NAME_PROP + n2 + ".urls");
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. host: '" + (String)object[0] + "', port: '" + (String)object[1] + "'" + ", urls: " + string);
            }
            String[] stringArray2 = string.split(",");
            stringArray.addProxy((String)object[0], (String)object[1], stringArray2);
            logger.finer("Proxy has been configured: '" + string2 + "' for " + string);
            ++n2;
        }
        if (bl) {
            ProxySelector.setDefault((ProxySelector)stringArray);
        }
        if (properties != null && bl) {
            String string5 = properties.getProperty(HTTP_AUTH_PREF_PROP);
            if (string5 != null) {
                string5 = string5.trim();
                System.setProperty(HTTP_AUTH_PREF_PROP, string5);
                logger.finer(string5 + " authentication enabled.");
                if (string5.equalsIgnoreCase(PROXY_AUTH_KERBEROS)) {
                    string2 = properties.getProperty(JAVA_SECURITY_KERBEROS_PROP);
                    object = properties.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG_PROP);
                    string = System.getenv().get("KRB5CCNAME");
                    if (string != null && object != null && string2 != null) {
                        string = string.trim();
                        object = ((String)object).trim();
                        string2 = string2.trim();
                        System.setProperty("user.krb5cc", string);
                        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                        System.setProperty(JAVA_SECURITY_KERBEROS_PROP, string2);
                        System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG_PROP, (String)object);
                        logger.finer("java.security.krb5.conf = " + string2);
                        logger.finer("java.security.auth.login.config = " + (String)object);
                        logger.finer("Environment variable KRB5CCNAME = " + string);
                    } else {
                        logger.warning("Kerberos ticket cache not configured because one of the parameters is not set.");
                        logger.warning("java.security.krb5.conf = " + string2);
                        logger.warning("java.security.auth.login.config = " + (String)object);
                        logger.warning("Environment variable KRB5CCNAME = " + string);
                    }
                } else if (string5.equalsIgnoreCase(PROXY_AUTH_BASIC)) {
                    string2 = properties.getProperty(HTTP_AUTH_USER_PROP);
                    object = properties.getProperty(PROXY_AUTH_PW_PROP);
                    Configuration.setCredentials(string5, string2, (String)object);
                } else {
                    logger.finer("Authentication type not supported: " + string5);
                }
            } else {
                logger.finer("No authentication enabled.");
            }
        }
        logger.exiting(sourceClass, "configureProxy");
    }

    private static void setCredentials(String string, String string2, String string3) {
        Object object;
        Object object2;
        System.setProperty(HTTP_AUTH_PREF_PROP, string);
        if (string2 == null || string3 == null) {
            object2 = new JFrame("Proxy Authentication");
            ((JFrame)object2).setDefaultCloseOperation(2);
            object = new LoginDialog((Frame)object2, "Proxy Authentication");
            ((Dialog)object).setVisible(true);
            string2 = ((LoginDialog)object).getUsername();
            string3 = ((LoginDialog)object).getPassword();
            ((Window)object2).dispose();
        }
        object2 = string2.trim();
        object = string3.trim();
        Authenticator.setDefault(new Authenticator((String)object2, (String)object){
            final /* synthetic */ String val$user;
            final /* synthetic */ String val$pw;
            {
                this.val$user = string;
                this.val$pw = string2;
            }

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                Logger logger = SDMX_LOGGER;
                logger.entering(sourceClass, "getPasswordAuthentication");
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(this.val$user, this.val$pw.toCharArray());
                logger.finer("Requesting Host  : " + this.getRequestingHost());
                logger.finer("Requesting Port  : " + this.getRequestingPort());
                logger.finer("Requesting Protocol: " + this.getRequestingProtocol());
                logger.finer("Requesting Scheme : " + this.getRequestingScheme());
                logger.entering(sourceClass, "getPasswordAuthentication");
                return passwordAuthentication;
            }
        });
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("win") >= 0;
    }
}

