/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.util;

import it.bankitalia.reri.sia.util.Configuration;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;

public class SdmxProxySelector
extends ProxySelector {
    private ArrayList<Proxy> noProxy = null;
    private Hashtable<String, Proxy> proxyTable = null;
    private static final String sourceClass = SdmxProxySelector.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();

    public SdmxProxySelector() {
        logger.entering(sourceClass, "SdmxWSProxySelector");
        this.noProxy = new ArrayList();
        Proxy proxy = Proxy.NO_PROXY;
        this.noProxy.add(proxy);
        this.proxyTable = new Hashtable();
        logger.exiting(sourceClass, "SdmxWSProxySelector");
    }

    public void addProxy(String string, String string2, String[] stringArray) {
        logger.entering(sourceClass, "addProxy");
        if (string != null && string2 != null && !string.isEmpty() && !string2.isEmpty()) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string.trim(), Integer.parseInt(string2.trim())));
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i].trim();
                if (string3 == null || string3.isEmpty()) continue;
                this.proxyTable.put(string3, proxy);
                logger.finer("Proxy has been added: '" + proxy.address().toString() + "' for " + string3);
            }
        } else {
            throw new IllegalArgumentException("Proxy settings must be valid. host: '" + string + "', port: '" + string2 + "'");
        }
        logger.exiting(sourceClass, "addProxy");
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        logger.entering(sourceClass, "connectFailed");
        logger.warning("FAILED PROXY CALL to URI: " + uRI + ", socket: " + socketAddress);
        logger.exiting(sourceClass, "connectFailed");
    }

    @Override
    public List<Proxy> select(URI uRI) {
        ArrayList<Proxy> arrayList = this.noProxy;
        logger.entering(sourceClass, "select");
        logger.finer("Getting proxy for host: " + uRI.getHost());
        Proxy proxy = this.proxyTable.get(uRI.getHost());
        if (proxy != null) {
            arrayList = new ArrayList();
            arrayList.add(proxy);
        }
        logger.finer("proxy: " + arrayList);
        logger.exiting(sourceClass, "select");
        return arrayList;
    }
}

