/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.polynomials.AbstractRootSelector;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;

public class SeasonalSelector
extends AbstractRootSelector {
    private double m_k = 0.5;
    private double m_epsphi = Math.PI / 90;
    private int m_freq;

    public SeasonalSelector() {
        this.m_freq = 12;
    }

    public SeasonalSelector(int freq) {
        this.m_freq = freq;
    }

    public SeasonalSelector(int freq, double epsphi) {
        this.m_freq = freq;
        this.m_epsphi = epsphi;
    }

    @Override
    public boolean accept(Complex root) {
        if (Math.abs(root.getIm()) < 1.0E-6) {
            return 1.0 / root.getRe() < -this.m_k;
        }
        double pi = Math.PI * 2 / (double)this.m_freq;
        double arg = Math.abs(root.arg());
        double eps = this.m_epsphi / 180.0 * Math.PI;
        for (int i = 1; i <= this.m_freq / 2; ++i) {
            if (!(Math.abs(pi * (double)i - arg) <= eps)) continue;
            return true;
        }
        return false;
    }

    public int getFrequency() {
        return this.m_freq;
    }

    public double getK() {
        return this.m_k;
    }

    public double getTolerance() {
        return this.m_epsphi;
    }

    public void setFrequency(int value) {
        this.m_freq = value;
    }

    public void setK(double value) {
        this.m_k = value;
    }

    public void setTolerance(double value) {
        this.m_epsphi = value;
    }

    @Override
    public boolean selectUnitRoots(Polynomial p) {
        Polynomial.Division div;
        this.m_sel = Polynomial.ONE;
        this.m_nsel = p;
        if (this.m_freq == 1) {
            return false;
        }
        Polynomial S = UnitRoots.S(this.m_freq, 1);
        while ((div = Polynomial.divide(this.m_nsel, S)).isExact()) {
            this.m_sel = this.m_sel.times(S);
            this.m_nsel = div.getQuotient();
            if (p.getDegree() >= S.getDegree()) continue;
        }
        return this.m_sel.getDegree() > 0;
    }
}

