/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.arima.CrossCovarianceFunction;
import ec.tstoolkit.arima.LinearModel;

public class BartlettApproximation {
    private LinearModel m_xmodel;
    private LinearModel m_ymodel;
    private double[] m_xc;
    private double[] m_yc;
    private double[] m_xycp;
    private double[] m_xycn;
    private static final int g_max = 1000;

    public double autoCovariance(int k) throws ArimaException {
        this.calc();
        if (this.m_xc == null) {
            throw new ArimaException("arima_err_init");
        }
        return this.m_xc[k] * this.m_xmodel.getAutoCovarianceFunction().get(0);
    }

    private double xycp(int i) {
        return i >= this.m_xycp.length ? 0.0 : this.m_xycp[i];
    }

    private double xycn(int i) {
        return i >= this.m_xycn.length ? 0.0 : this.m_xycn[i];
    }

    private double xc(int i) {
        return i >= this.m_xc.length ? 0.0 : this.m_xc[i];
    }

    private double yc(int i) {
        return i >= this.m_yc.length ? 0.0 : this.m_yc[i];
    }

    private void calc() throws ArimaException {
        if (!(this.m_xmodel != null && this.m_xc == null || this.m_ymodel != null && this.m_yc == null)) {
            return;
        }
        if (this.m_xmodel != null && this.m_xc == null) {
            this.m_xc = this.prepare(this.m_xmodel);
        }
        if (this.m_ymodel != null && this.m_yc == null) {
            this.m_yc = this.prepare(this.m_ymodel);
        }
        if (this.m_ymodel != null && this.m_xmodel != null && this.m_xycp == null && this.m_xycn == null) {
            this.prepare(this.m_xmodel, this.m_ymodel);
        }
    }

    private int calctruncationpoint(AutoCovarianceFunction acgf) {
        int b;
        int n = b = acgf.hasBound() ? acgf.getBound() : 1000;
        if (b > 1000) {
            b = 1000;
        }
        return b;
    }

    private void clearx() {
        this.m_xc = null;
        this.m_xycp = null;
        this.m_xycn = null;
    }

    private void cleary() {
        this.m_yc = null;
        this.m_xycp = null;
        this.m_xycn = null;
    }

    public double crossCorrelation(int k) throws ArimaException {
        this.calc();
        if (this.m_xycp == null || this.m_xycn == null) {
            throw new ArimaException("arima_err_init");
        }
        if (k >= 0) {
            return this.xycp(k);
        }
        return this.xycn(-k);
    }

    public LinearModel getX() {
        return this.m_xmodel;
    }

    public LinearModel getY() {
        return this.m_ymodel;
    }

    private void initxmodel(LinearModel model) {
        this.m_xmodel = model;
        this.clearx();
    }

    private void initymodel(LinearModel model) {
        this.m_ymodel = model;
        this.cleary();
    }

    private double[] prepare(LinearModel model) throws ArimaException {
        AutoCovarianceFunction acgf = model.getAutoCovarianceFunction();
        int m = this.calctruncationpoint(acgf);
        acgf.prepare(m + 1);
        double[] c = new double[m + 1];
        double var = acgf.get(0);
        c[0] = 1.0;
        for (int i = 1; i <= m; ++i) {
            c[i] = acgf.get(i) / var;
        }
        return c;
    }

    private void prepare(LinearModel x, LinearModel y) throws ArimaException {
        int i;
        CrossCovarianceFunction ccgf = new CrossCovarianceFunction(x, y);
        int mn = ccgf.hasLBound() ? -ccgf.getLBound() : 1000;
        int mp = ccgf.hasUBound() ? ccgf.getUBound() : 1000;
        this.m_xycn = new double[mn + 1];
        this.m_xycp = new double[mp + 1];
        ccgf.prepare(-mn - 1, mp + 1);
        double denom = Math.sqrt(x.getAutoCovarianceFunction().get(0) * y.getAutoCovarianceFunction().get(0));
        for (i = 0; i >= -mn; --i) {
            this.m_xycn[-i] = ccgf.get(i) / denom;
        }
        for (i = 0; i <= mp; ++i) {
            this.m_xycp[i] = ccgf.get(i) / denom;
        }
    }

    public double SDAutoCorrelation(int samplesize, int k) throws ArimaException {
        this.calc();
        if (this.m_xc == null) {
            throw new ArimaException("arima_err_init");
        }
        if (k < 0) {
            k = -k;
        }
        double rk = this.xc(k);
        double v = 1.0 - rk * rk;
        int m = this.m_xc.length - 1;
        for (int j = 1; j <= m; ++j) {
            double rj = this.xc(j);
            double rjpk = this.xc(j + k);
            double rjmk = j - k < 0 ? this.xc(k - j) : this.xc(j - k);
            v += 2.0 * (rj * rj * (1.0 + 2.0 * rk * rk) + rjpk * rjmk - 2.0 * rj * rk * (rjpk + rjmk));
        }
        return Math.sqrt(v / (double)samplesize);
    }

    public double SDCrossCorrelation(int samplesize, int k) throws ArimaException {
        this.calc();
        if (this.m_xc == null || this.m_yc == null) {
            throw new ArimaException("arima_err_init");
        }
        double v = 0.0;
        int mn = this.m_xycn.length - 1;
        int mp = this.m_xycp.length - 1;
        for (int i = -mn; i <= mp; ++i) {
            int I = Math.abs(i);
            int ipk = i + k;
            int imk = i - k;
            int IPK = Math.abs(ipk);
            double rxi = this.xc(I);
            double ryi = this.yc(I);
            double ryipk = this.yc(IPK);
            double rxyipk = 0.0;
            double rxyimk = 0.0;
            double rxyk = 0.0;
            double rxymi = 0.0;
            double rxyi = 0.0;
            if (ipk <= mp) {
                if (ipk >= 0) {
                    rxyipk = this.m_xycp[ipk];
                } else if (-ipk <= mn) {
                    rxyipk = this.m_xycn[-ipk];
                }
            }
            if (imk <= mp) {
                if (imk >= 0) {
                    rxyimk = this.m_xycp[imk];
                } else if (-imk <= mn) {
                    rxyimk = this.m_xycn[-imk];
                }
            }
            if (k <= mp) {
                if (k >= 0) {
                    rxyk = this.m_xycp[k];
                } else if (-k <= mn) {
                    rxyk = this.m_xycn[-k];
                }
            }
            if (-i <= mp) {
                if (-i >= 0) {
                    rxymi = this.m_xycp[-i];
                } else if (i <= mn) {
                    rxymi = this.m_xycn[i];
                }
            }
            if (i <= mp) {
                if (i >= 0) {
                    rxyi = this.m_xycp[i];
                } else if (-i <= mn) {
                    rxyi = this.m_xycn[-i];
                }
            }
            v += rxi * ryi + rxyimk * rxyipk - 2.0 * rxyk * (rxi * rxyipk + rxymi * ryipk) + rxyk * rxyk * (rxyi * rxyi + 0.5 * rxi * rxi + 0.5 * ryi * ryi);
        }
        return Math.sqrt(v / (double)(samplesize - k));
    }

    public double SDVar(int samplesize) throws ArimaException {
        this.calc();
        if (this.m_xc == null) {
            throw new ArimaException("arima_err_init");
        }
        double v = 2.0;
        int m = this.m_xc.length - 1;
        for (int i = 1; i <= m; ++i) {
            v += 4.0 * this.m_xc[i] * this.m_xc[i];
        }
        return this.m_xmodel.getAutoCovarianceFunction().get(0) * Math.sqrt(v /= (double)samplesize);
    }

    public void setX(LinearModel value) {
        this.initxmodel(value);
    }

    public void setY(LinearModel value) {
        this.initymodel(value);
    }
}

