/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.IEndPointsProcessor;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.IFiniteFilter;

public class AsymmetricEndPoints
implements IEndPointsProcessor {
    private IFiniteFilter[] filters;

    public AsymmetricEndPoints(IFiniteFilter[] filters) {
        this.filters = filters;
    }

    @Override
    public void process(DataBlock in, DataBlock out) {
        int plen2;
        int istart;
        int n = this.filters.length;
        int plen = in.getLength();
        int ifilter = 2 * n - plen;
        if (ifilter < 0) {
            ifilter = 0;
        }
        if ((istart = n - ifilter) > (plen2 = (plen + 1) / 2)) {
            istart = plen2;
            ifilter = n - istart;
        }
        int rlen = 2 * n - ifilter;
        DataBlock beg = in.range(0, rlen).reverse();
        DataBlock end = in.range(plen - rlen, plen);
        int icur = istart;
        while (icur > 0) {
            DataBlock f = new DataBlock(this.filters[ifilter++].getWeights());
            out.set(plen - icur, f.dot(end));
            end.bshrink();
            out.set(--icur, f.dot(beg));
            beg.bshrink();
        }
        if (istart < n) {
            double av = in.sum() / (double)plen;
            out.range(istart, plen - istart).set(av);
        }
    }

    public int getEndPointsCount() {
        return this.filters.length;
    }
}

