/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.IProcessingHook;
import ec.tstoolkit.algorithm.IProcessingHookProvider;
import ec.tstoolkit.information.InformationSet;
import java.util.ArrayList;

public class ProcessingHookProvider<S, I>
implements IProcessingHookProvider<S, I> {
    private final ArrayList<IProcessingHook<S, I>> hooks = new ArrayList();
    private volatile String message = "";

    @Override
    public void setHookMessage(String msg) {
        this.message = msg;
    }

    @Override
    public String getHookMessage() {
        return this.message;
    }

    @Override
    public synchronized boolean hasHooks() {
        return !this.hooks.isEmpty();
    }

    @Override
    public synchronized void register(IProcessingHook<S, I> hook) {
        this.hooks.add(hook);
    }

    @Override
    public synchronized void unregister(IProcessingHook<S, I> hook) {
        for (IProcessingHook<S, I> cur : this.hooks) {
            if (hook != cur) continue;
            this.hooks.remove(cur);
            return;
        }
    }

    @Override
    public synchronized void processHooks(IProcessingHook.HookInformation<S, I> info, boolean cancancel) {
        info.message = InformationSet.item(this.message, info.message);
        for (IProcessingHook<S, I> cur : this.hooks) {
            cur.process(info, cancancel);
            if (!cancancel || !info.cancel) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyHooks(ProcessingHookProvider<S, I> ph) {
        ArrayList<IProcessingHook<S, I>> arrayList = ph.hooks;
        synchronized (arrayList) {
            this.hooks.addAll(ph.hooks);
            this.message = ph.message;
        }
    }
}

