/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.seats.DefaultBiasCorrector;
import ec.satoolkit.seats.DefaultModelApproximator3;
import ec.satoolkit.seats.DefaultModelBuilder;
import ec.satoolkit.seats.DefaultModelDecomposer;
import ec.satoolkit.seats.DefaultModelEstimator;
import ec.satoolkit.seats.DefaultModelValidator;
import ec.satoolkit.seats.IArimaDecomposer;
import ec.satoolkit.seats.IBiasCorrector;
import ec.satoolkit.seats.IComponentsEstimator;
import ec.satoolkit.seats.IModelApproximator;
import ec.satoolkit.seats.IModelBuilder;
import ec.satoolkit.seats.IModelValidator;
import ec.satoolkit.seats.ISeatsToolkit;
import ec.satoolkit.seats.KalmanEstimator;
import ec.satoolkit.seats.MatrixEstimator;
import ec.satoolkit.seats.SeatsContext;
import ec.satoolkit.seats.SeatsSpecification;
import ec.satoolkit.seats.WienerKolmogorovEstimator;

public class SeatsToolkit
implements ISeatsToolkit {
    private final SeatsContext context;
    private IModelBuilder modelBuilder;
    private IModelValidator modelValidator;
    private IModelApproximator modelApproximator;
    private IArimaDecomposer modelDecomposer;
    private IComponentsEstimator componentsEstimator;
    private IBiasCorrector biasCorrector;

    public static SeatsToolkit create(SeatsSpecification spec) {
        IComponentsEstimator cmpEstimator;
        DefaultModelValidator validator = new DefaultModelValidator();
        validator.setXl(spec.getXlBoundary());
        SeatsContext context = new SeatsContext(spec.getApproximationMode(), spec.isLog());
        SeatsToolkit toolkit = new SeatsToolkit(context);
        context.setEstimator(new DefaultModelEstimator(validator));
        DefaultModelBuilder builder = new DefaultModelBuilder(spec.getArima());
        toolkit.modelBuilder = builder;
        toolkit.modelValidator = validator;
        DefaultModelApproximator3 approximator = new DefaultModelApproximator3();
        toolkit.modelApproximator = approximator;
        DefaultModelDecomposer decomposer = new DefaultModelDecomposer(spec.getApproximationMode() == SeatsSpecification.ApproximationMode.Noisy);
        decomposer.setEpsphi(spec.getSeasTolerance());
        decomposer.setRmod(spec.getTrendBoundary());
        decomposer.setSmod(spec.getSeasBoundary());
        decomposer.setSmod1(spec.getSeasBoundary1());
        toolkit.modelDecomposer = decomposer;
        switch (spec.getMethod()) {
            case KalmanSmoother: {
                cmpEstimator = new KalmanEstimator(spec.getPredictionLength());
                break;
            }
            case McElroyMatrix: {
                cmpEstimator = new MatrixEstimator(spec.getPredictionLength());
                break;
            }
            default: {
                cmpEstimator = new WienerKolmogorovEstimator(spec.getPredictionLength());
            }
        }
        toolkit.componentsEstimator = cmpEstimator;
        DefaultBiasCorrector corrector = new DefaultBiasCorrector();
        toolkit.biasCorrector = corrector;
        return toolkit;
    }

    SeatsToolkit(SeatsContext context) {
        this.context = context;
    }

    @Override
    public IBiasCorrector getBiasCorrector() {
        return this.biasCorrector;
    }

    @Override
    public IComponentsEstimator getComponentsEstimator() {
        return this.componentsEstimator;
    }

    @Override
    public SeatsContext getContext() {
        return this.context;
    }

    @Override
    public IModelApproximator getModelApproximator() {
        return this.modelApproximator;
    }

    @Override
    public IArimaDecomposer getModelDecomposer() {
        return this.modelDecomposer;
    }

    @Override
    public IModelValidator getModelValidator() {
        return this.modelValidator;
    }

    @Override
    public IModelBuilder getModelBuilder() {
        return this.modelBuilder;
    }
}

