/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.Chi2;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.AutoCorrelations;
import ec.tstoolkit.stats.StatisticalTest;

public class LjungBoxTest
extends StatisticalTest {
    AutoCorrelations ac;
    private int m_lag = 1;
    private int m_k = 12;
    private int m_hp;
    private boolean m_pos;

    public int getHyperParametersCount() {
        return this.m_hp;
    }

    public int getK() {
        return this.m_k;
    }

    public int getLag() {
        return this.m_lag;
    }

    @Override
    public boolean isValid() {
        if (!this.m_computed) {
            this.test();
        }
        return this.m_dist != null;
    }

    public void setHyperParametersCount(int value) {
        if (this.m_hp != value) {
            this.m_hp = value;
            this.clear();
        }
    }

    public void setK(int value) {
        if (this.m_k != value) {
            this.m_k = value;
            this.clear();
        }
    }

    public void setLag(int value) {
        if (this.m_lag != value) {
            this.m_lag = value;
            this.m_pos = this.m_lag > 1;
            this.clear();
        }
    }

    public void usePositiveAc(boolean pos) {
        this.m_pos = pos;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test() {
        try {
            this.ac.setKMax(this.m_k * this.m_lag);
            if (this.ac.getKMax() < this.m_k * this.m_lag) {
                this.m_k = this.ac.getKMax() / this.m_lag;
            }
            double[] a = this.ac.getAC();
            int n = this.ac.stats.getDataCount();
            double res = 0.0;
            for (int i = 1; i <= this.m_k; ++i) {
                double ai = a[i * this.m_lag - 1];
                if (this.m_pos && !(ai > 0.0)) continue;
                res += ai * ai / (double)(n - i * this.m_lag);
            }
            this.m_val = res * (double)n * (double)(n + 2);
            Chi2 chi = new Chi2();
            chi.setDegreesofFreedom(this.m_lag == 1 ? this.m_k - this.m_hp : this.m_k);
            this.m_dist = chi;
            this.m_type = TestType.Upper;
            this.m_asympt = true;
        }
        catch (Exception err) {
            this.m_dist = null;
        }
        finally {
            this.m_computed = true;
        }
    }

    public void test(AutoCorrelations ac) {
        this.ac = ac;
        this.test();
    }

    public void test(IReadDataBlock data) {
        this.ac = new AutoCorrelations(data);
        this.test();
    }

    public static double calc(double[] data, int lag, int k, boolean pos) {
        int n = data.length;
        double res = 0.0;
        double v = DescriptiveStatistics.cov(0, data);
        for (int i = 1; i <= k; ++i) {
            double ac = DescriptiveStatistics.cov(lag * i, data) / v;
            if (!pos || ac > 0.0) {
                res += ac * ac / (double)(n - i * lag);
                continue;
            }
            if (i != 1) continue;
            return 0.0;
        }
        return res *= (double)(n * (n + 2));
    }
}

