/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.arima;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;

public class SsfRw
implements ISsf {
    private boolean m_zeroinit;

    @Override
    public void diffuseConstraints(SubMatrix b) {
        this.Pi0(b);
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        qm.set(0, 0, 1.0);
    }

    @Override
    public int getNonStationaryDim() {
        return this.m_zeroinit ? 0 : 1;
    }

    @Override
    public int getStateDim() {
        return 1;
    }

    @Override
    public int getTransitionResCount() {
        return 1;
    }

    @Override
    public int getTransitionResDim() {
        return 1;
    }

    @Override
    public boolean hasR() {
        return false;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    @Override
    public boolean isDiffuse() {
        return !this.m_zeroinit;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    public boolean isUsingZeroInitialization() {
        return this.m_zeroinit;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        lm.set(0, 0, 1.0 - k.get(0));
    }

    @Override
    public void Pf0(SubMatrix pf0) {
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        if (!this.m_zeroinit) {
            pi0.set(0, 0, 1.0);
        }
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        qm.set(0, 0, 1.0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        tr.set(0, 0, 1.0);
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
    }

    @Override
    public void TX(int pos, DataBlock x) {
    }

    public void useZeroInitialization(boolean value) {
        this.m_zeroinit = value;
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        vm.add(d);
    }

    @Override
    public void W(int pos, SubMatrix wv) {
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        x.add(d);
    }

    @Override
    public void XT(int pos, DataBlock x) {
    }

    @Override
    public void Z(int pos, DataBlock x) {
        x.set(0, 1.0);
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        x.copy(m.row(0));
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        return vm.get(0, 0);
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        return x.get(0);
    }
}

