/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.information.InformationSet;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class BatchProcessing
implements IProcessing<InformationSet, CompositeResults>,
Cloneable {
    private ArrayList<Node<?, ?>> nodes_ = new ArrayList();

    public BatchProcessing clone() {
        try {
            BatchProcessing p = (BatchProcessing)super.clone();
            return p;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public void add(Node<?, ?> node) {
        this.nodes_.add(node);
    }

    @Override
    public CompositeResults process(InformationSet input) {
        CompositeResults results = new CompositeResults();
        for (Node<?, ?> cur : this.nodes_) {
            cur.process(input, results);
        }
        return results;
    }

    public static class Node<S, R extends IProcResults> {
        public final String name;
        public final ILink<S> link;
        public final IProcessing<S, R> processing;

        public Node(String name, ILink<S> link, IProcessing<S, R> processing) {
            this.name = name;
            this.link = link;
            this.processing = processing;
        }

        public boolean process(InformationSet input, CompositeResults context) {
            S sinput = this.link.createInput(input, context);
            R r = this.processing.process(sinput);
            if (r == null) {
                return false;
            }
            context.put(this.name, (IProcResults)r, this.name);
            return true;
        }
    }

    public static class InputLink<S>
    implements ILink<S> {
        private final String id;
        private final Class<S> sclass;

        public InputLink(String id, Class<S> sclass) {
            this.id = id;
            this.sclass = sclass;
        }

        @Override
        public S createInput(InformationSet input, CompositeResults context) {
            return input.search(this.id, this.sclass);
        }
    }

    public static class OutputLink<R extends IProcResults>
    implements ILink<R> {
        private final String id;
        private final Class<R> rclass;

        public OutputLink(String id, Class<R> rclass) {
            this.id = id;
            this.rclass = rclass;
        }

        @Override
        public R createInput(InformationSet input, CompositeResults context) {
            return context.get(this.id, this.rclass);
        }
    }

    public static class Links<S>
    implements ILink<S[]> {
        private final String[] id;
        private final Class<S> sclass;

        public Links(String[] id, Class<S> sclass) {
            this.id = id;
            this.sclass = sclass;
        }

        @Override
        public S[] createInput(InformationSet input, CompositeResults context) {
            Object[] rslt = (Object[])Array.newInstance(this.sclass, this.id.length);
            for (int i = 0; i < rslt.length; ++i) {
                rslt[i] = context.getData(this.id[i], this.sclass);
            }
            return rslt;
        }
    }

    public static class Link<S>
    implements ILink<S> {
        private final String id;
        private final Class<S> sclass;

        public Link(String id, Class<S> sclass) {
            this.id = id;
            this.sclass = sclass;
        }

        @Override
        public S createInput(InformationSet input, CompositeResults context) {
            return context.getData(this.id, this.sclass);
        }
    }

    public static interface ILink<S> {
        public S createInput(InformationSet var1, CompositeResults var2);
    }
}

