/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.simplets;

import ec.benchmarking.ssf.SsfCalendarization;
import ec.benchmarking.ssf.SsfCalendarizationEx;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.ssf.DisturbanceSmoother;
import ec.tstoolkit.ssf.Smoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.DayOfWeek;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

public class Calendarization {
    private final boolean stdev_;
    private Day start_;
    private Day end_;
    private double[] s_;
    private double[] es_;
    private final EnumMap<TsFrequency, TsData[]> output_ = new EnumMap(TsFrequency.class);
    private double[] dweights_;
    private final ArrayList<PeriodObs> data_ = new ArrayList();

    public Calendarization() {
        this.stdev_ = true;
    }

    public Calendarization(boolean stdev) {
        this.stdev_ = stdev;
    }

    public List<PeriodObs> getData() {
        return Collections.unmodifiableList(this.data_);
    }

    public boolean setSpan(Day start, Day end) {
        if (!end.isAfter(start)) {
            return false;
        }
        this.start_ = start;
        this.end_ = end;
        return true;
    }

    public void clearData() {
        this.data_.clear();
        this.update();
    }

    public void setDailyWeights(double[] w) {
        this.update();
        this.dweights_ = w;
    }

    public void setDailyWeight(DayOfWeek dw, double w) {
        this.update();
        if (this.dweights_ == null) {
            this.dweights_ = new double[7];
            for (int i = 0; i < this.dweights_.length; ++i) {
                this.dweights_[i] = 1.0;
            }
        }
        this.dweights_[dw.intValue()] = w;
    }

    public double getDailyWeight(DayOfWeek w) {
        if (this.dweights_ == null) {
            return 1.0;
        }
        return this.dweights_[w.intValue()];
    }

    public boolean add(Day start, Day end, double value) {
        Day last;
        if (!end.isAfter(start)) {
            return false;
        }
        if (!this.data_.isEmpty() && !start.isAfter(last = this.data_.get((int)(this.data_.size() - 1)).end)) {
            return false;
        }
        this.data_.add(new PeriodObs(start, end, value));
        this.update();
        return true;
    }

    @Deprecated
    public void clear() {
        this.output_.clear();
        this.s_ = null;
        this.es_ = null;
    }

    public void update() {
        this.output_.clear();
        this.s_ = null;
        this.es_ = null;
    }

    private boolean process(TsFrequency freq) {
        if (!this.stdev_) {
            return this.fastProcess();
        }
        return this.fullProcess(freq);
    }

    private boolean fastProcess() {
        double[] w;
        if (this.s_ != null) {
            return true;
        }
        Day start = this.data_.get((int)0).start;
        Day end = this.data_.get((int)(this.data_.size() - 1)).end;
        if (this.start_.isBefore(start)) {
            start = this.start_;
        }
        if (this.end_.isAfter(end)) {
            end = this.end_;
        }
        double[] data = new double[end.difference(start) + 1];
        if (this.dweights_ != null) {
            w = new double[data.length];
            int j = start.getDayOfWeek().intValue();
            for (int i = 0; i < w.length; ++i) {
                w[i] = this.dweights_[j];
                if (++j != 7) continue;
                j = 0;
            }
        } else {
            w = null;
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = Double.NaN;
        }
        int[] starts = new int[this.data_.size()];
        int idx = 0;
        for (PeriodObs obs : this.data_) {
            starts[idx++] = obs.start.difference(start);
            int n = obs.end.difference(start);
            data[n] = obs.value;
        }
        DisturbanceSmoother smoother = new DisturbanceSmoother();
        smoother.setSsf(new SsfCalendarization(starts, w));
        smoother.process(new SsfData(data, null));
        SmoothingResults sstates = smoother.calcSmoothedStates();
        double[] c = sstates.component(1);
        if (w != null) {
            for (int i = 0; i < c.length; ++i) {
                int n = i;
                c[n] = c[n] * w[i];
            }
        }
        this.s_ = c;
        return true;
    }

    private boolean fullProcess(TsFrequency freq) {
        int i;
        double[] w;
        if (freq == TsFrequency.Undefined) {
            if (this.s_ != null) {
                return true;
            }
            return this.fastFullProcess();
        }
        if (this.output_.containsKey(freq)) {
            return true;
        }
        Day start = this.data_.get((int)0).start;
        Day end = this.data_.get((int)(this.data_.size() - 1)).end;
        if (this.start_.isBefore(start)) {
            start = this.start_;
        }
        if (this.end_.isAfter(end)) {
            end = this.end_;
        }
        double[] data = new double[end.difference(start) + 1];
        if (this.dweights_ != null) {
            w = new double[data.length];
            int j = start.getDayOfWeek().intValue();
            for (int i2 = 0; i2 < w.length; ++i2) {
                w[i2] = this.dweights_[j];
                if (++j != 7) continue;
                j = 0;
            }
        } else {
            w = null;
        }
        for (int i3 = 0; i3 < data.length; ++i3) {
            data[i3] = Double.NaN;
        }
        int[] starts = new int[this.data_.size()];
        TsPeriod S = new TsPeriod(freq, start);
        TsPeriod E = new TsPeriod(freq, end);
        int[] astarts = new int[E.minus(S) + 1];
        for (int i4 = 0; i4 < astarts.length; ++i4) {
            astarts[i4] = Math.max(0, S.plus(i4).firstday().difference(start));
        }
        int idx = 0;
        for (PeriodObs obs : this.data_) {
            starts[idx++] = obs.start.difference(start);
            int n = obs.end.difference(start);
            data[n] = obs.value;
        }
        Smoother smoother = new Smoother();
        smoother.setCalcVar(true);
        smoother.setSsf(new SsfCalendarizationEx(starts, astarts, w));
        SmoothingResults sstates = new SmoothingResults(true, true);
        smoother.process(new SsfData(data, null), sstates);
        if (this.s_ == null) {
            double[] c = sstates.component(2);
            if (w != null) {
                for (i = 0; i < c.length; ++i) {
                    int n = i;
                    c[n] = c[n] * w[i];
                }
            }
            this.s_ = c;
        }
        if (this.es_ == null) {
            double[] e = sstates.componentStdev(2);
            if (w != null) {
                for (i = 0; i < e.length; ++i) {
                    int n = i;
                    e[n] = e[n] * w[i];
                }
            }
            this.es_ = e;
        }
        TsData X = new TsData(S, astarts.length);
        TsData EX = new TsData(S, astarts.length);
        int[] aends = new int[astarts.length];
        for (int i5 = 1; i5 < astarts.length; ++i5) {
            aends[i5 - 1] = astarts[i5] - 1;
        }
        aends[aends.length - 1] = this.s_.length - 1;
        DataBlock Z = new DataBlock(3);
        Z.set(1, 1.0);
        Z.set(2, 1.0);
        for (int i6 = 0; i6 < aends.length; ++i6) {
            int icur = aends[i6];
            if (w != null) {
                Z.set(2, w[icur]);
            }
            X.set(i6, sstates.zcomponent(icur, Z));
            EX.set(i6, Math.sqrt(Math.max(0.0, sstates.zvariance(icur, Z))));
        }
        this.output_.put(freq, new TsData[]{X, EX});
        return true;
    }

    private boolean fastFullProcess() {
        double[] w;
        Day start = this.data_.get((int)0).start;
        Day end = this.data_.get((int)(this.data_.size() - 1)).end;
        if (this.start_.isBefore(start)) {
            start = this.start_;
        }
        if (this.end_.isAfter(end)) {
            end = this.end_;
        }
        double[] data = new double[end.difference(start) + 1];
        if (this.dweights_ != null) {
            w = new double[data.length];
            int j = start.getDayOfWeek().intValue();
            for (int i = 0; i < w.length; ++i) {
                w[i] = this.dweights_[j];
                if (++j != 7) continue;
                j = 0;
            }
        } else {
            w = null;
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = Double.NaN;
        }
        int[] starts = new int[this.data_.size()];
        int idx = 0;
        for (PeriodObs obs : this.data_) {
            starts[idx++] = obs.start.difference(start);
            int n = obs.end.difference(start);
            data[n] = obs.value;
        }
        Smoother smoother = new Smoother();
        smoother.setCalcVar(true);
        smoother.setSsf(new SsfCalendarization(starts, w));
        SmoothingResults sstates = new SmoothingResults(true, true);
        smoother.process(new SsfData(data, null), sstates);
        double[] c = sstates.component(1);
        double[] e = sstates.componentStdev(1);
        if (w != null) {
            for (int i = 0; i < c.length; ++i) {
                int n = i;
                c[n] = c[n] * w[i];
                int n2 = i;
                e[n2] = e[n2] * w[i];
            }
        }
        this.s_ = c;
        this.es_ = e;
        return true;
    }

    private TsData makeTsData(TsFrequency freq) {
        Day start = this.data_.get((int)0).start;
        Day end = this.data_.get((int)(this.data_.size() - 1)).end;
        if (this.start_.isBefore(start)) {
            start = this.start_;
        }
        if (this.end_.isAfter(end)) {
            end = this.end_;
        }
        TsPeriod S = new TsPeriod(freq, start);
        TsPeriod E = new TsPeriod(freq, end);
        double[] sum = new double[E.minus(S) + 1];
        TsPeriod cur = S.clone();
        int j0 = 0;
        int j1 = 0;
        for (int i = 0; i < sum.length; ++i) {
            j1 = Math.min(cur.lastday().difference(start) + 1, this.s_.length);
            double s = 0.0;
            for (int j = j0; j < j1; ++j) {
                s += this.s_[j];
            }
            sum[i] = s;
            cur.move(1);
            j0 = j1;
        }
        return new TsData(S, sum, false);
    }

    public Day getStart() {
        return this.start_;
    }

    public Day getEnd() {
        return this.end_;
    }

    public double[] getSmoothedData() {
        if (!this.process(TsFrequency.Undefined)) {
            return null;
        }
        return this.s_;
    }

    public TsData getAggregates(TsFrequency freq) {
        if (!this.process(freq)) {
            return null;
        }
        if (!this.stdev_) {
            return this.makeTsData(freq);
        }
        TsData[] o = this.output_.get(freq);
        return o == null ? null : o[0];
    }

    public double[] getSmoothedStdev() {
        if (!this.stdev_ || !this.process(TsFrequency.Undefined)) {
            return null;
        }
        return this.es_;
    }

    public TsData getAggregatesStdev(TsFrequency freq) {
        if (!this.stdev_ || !this.process(freq)) {
            return null;
        }
        TsData[] o = this.output_.get(freq);
        return o == null ? null : o[1];
    }

    public static class PeriodObs {
        public final Day start;
        public final Day end;
        public double value;

        public PeriodObs(Day start, Day end, double v) {
            this.start = start;
            this.end = end;
            this.value = v;
        }
    }
}

