/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.arima.tramo.EasterSpec;
import ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec;
import java.util.Map;
import java.util.Objects;

public class CalendarSpec
implements Cloneable,
InformationSetSerializable {
    public static final String TD = "td";
    public static final String EASTER = "easter";
    private TradingDaysSpec td_ = new TradingDaysSpec();
    private EasterSpec easter_ = new EasterSpec();

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        EasterSpec.fillDictionary(InformationSet.item(prefix, EASTER), dic);
        TradingDaysSpec.fillDictionary(InformationSet.item(prefix, TD), dic);
    }

    public TradingDaysSpec getTradingDays() {
        return this.td_;
    }

    public void setTradingDays(TradingDaysSpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException(TD);
        }
        this.td_ = spec;
    }

    public EasterSpec getEaster() {
        return this.easter_;
    }

    public void setEaster(EasterSpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException(EASTER);
        }
        this.easter_ = spec;
    }

    public boolean isUsed() {
        return this.easter_.isUsed() || this.td_.isUsed();
    }

    public boolean isDefault() {
        return this.easter_.isDefault() && this.td_.isDefault();
    }

    public CalendarSpec clone() {
        try {
            CalendarSpec spec = (CalendarSpec)super.clone();
            spec.td_ = this.td_.clone();
            spec.easter_ = this.easter_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CalendarSpec && this.equals((CalendarSpec)obj);
    }

    private boolean equals(CalendarSpec other) {
        return Objects.equals(this.easter_, other.easter_) && Objects.equals(this.td_, other.td_);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + this.td_.hashCode();
        hash = 61 * hash + this.easter_.hashCode();
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet einfo;
        InformationSet tdinfo;
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet specInfo = new InformationSet();
        if ((verbose || !this.td_.isDefault()) && (tdinfo = this.td_.write(verbose)) != null) {
            specInfo.add(TD, tdinfo);
        }
        if ((verbose || !this.easter_.isDefault()) && (einfo = this.easter_.write(verbose)) != null) {
            specInfo.add(EASTER, einfo);
        }
        return specInfo;
    }

    @Override
    public boolean read(InformationSet info) {
        boolean tok;
        boolean tok2;
        InformationSet tdinfo = info.getSubSet(TD);
        if (tdinfo != null && !(tok2 = this.td_.read(tdinfo))) {
            return false;
        }
        InformationSet einfo = info.getSubSet(EASTER);
        return einfo == null || (tok = this.easter_.read(einfo));
    }
}

