/*
 * Decompiled with CFR 0.152.
 */
package jdr.spec.tramoseats;

import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import ec.tstoolkit.timeseries.regression.OutlierType;
import jdr.spec.tramoseats.BaseTramoSpec;
import jdr.spec.ts.SpanSelector;

public class OutlierSpec
extends BaseTramoSpec {
    OutlierSpec(TramoSpecification spec) {
        super(spec);
    }

    public String toString() {
        return "";
    }

    private ec.tstoolkit.modelling.arima.tramo.OutlierSpec inner() {
        return this.core.getOutliers();
    }

    public boolean isOutliersDetectionEnabled() {
        return this.inner().isUsed();
    }

    public void setOutliersDetectionEnabled(boolean value) {
        ec.tstoolkit.modelling.arima.tramo.OutlierSpec spec = this.inner();
        if (!value) {
            spec.clearTypes();
        } else {
            spec.add(OutlierType.AO);
            spec.add(OutlierType.LS);
            spec.add(OutlierType.TC);
        }
    }

    public SpanSelector getSpan() {
        return new SpanSelector(this.inner().getSpan());
    }

    public boolean isAO() {
        return this.inner().contains(OutlierType.AO);
    }

    public void setAO(boolean ao) {
        ec.tstoolkit.modelling.arima.tramo.OutlierSpec spec = this.inner();
        if (ao) {
            spec.add(OutlierType.AO);
        } else {
            spec.remove(OutlierType.AO);
        }
    }

    public boolean isLS() {
        return this.inner().contains(OutlierType.LS);
    }

    public void setLS(boolean ls) {
        ec.tstoolkit.modelling.arima.tramo.OutlierSpec spec = this.inner();
        if (ls) {
            spec.add(OutlierType.LS);
        } else {
            spec.remove(OutlierType.LS);
        }
    }

    public boolean isTC() {
        return this.inner().contains(OutlierType.TC);
    }

    public void setTC(boolean tc) {
        ec.tstoolkit.modelling.arima.tramo.OutlierSpec spec = this.inner();
        if (tc) {
            spec.add(OutlierType.TC);
        } else {
            spec.remove(OutlierType.TC);
        }
    }

    public boolean isSO() {
        return this.inner().contains(OutlierType.SO);
    }

    public void setSO(boolean so) {
        ec.tstoolkit.modelling.arima.tramo.OutlierSpec spec = this.inner();
        if (so) {
            spec.add(OutlierType.SO);
        } else {
            spec.remove(OutlierType.SO);
        }
    }

    public double getVa() {
        double va = this.inner().getCriticalValue();
        return va == 0.0 ? 3.5 : va;
    }

    public void setVa(double value) {
        this.inner().setCriticalValue(value);
    }

    public boolean isAutoVa() {
        return this.inner().getCriticalValue() == 0.0;
    }

    public void setAutoVa(boolean value) {
        this.inner().setCriticalValue(value ? 0.0 : 3.5);
    }

    public double getTCRate() {
        return this.inner().getDeltaTC();
    }

    public void setTCRate(double value) {
        this.inner().setDeltaTC(value);
    }

    public boolean isEML() {
        return this.inner().isEML();
    }

    public void setEML(boolean value) {
        this.inner().setEML(value);
    }
}

