/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public class RegressionVariables {
    private final ArrayList<Item<ITsVariable>> regs = new ArrayList();

    public static RegressionVariables makeCopy(RegressionVariables vars) {
        RegressionVariables nvars = new RegressionVariables();
        for (Item<ITsVariable> item : vars.regs) {
            nvars.regs.add(new Item(item.variable, Parameter.clone(item.coefficients)));
        }
        return nvars;
    }

    public static RegressionVariables select(RegressionVariables vars, Predicate<ITsVariable> predicate) {
        RegressionVariables nvars = new RegressionVariables();
        for (Item<ITsVariable> item : vars.regs) {
            if (!predicate.test((ITsVariable)item.variable)) continue;
            nvars.regs.add(new Item(item.variable, Parameter.clone(item.coefficients)));
        }
        return nvars;
    }

    public <T extends ITsVariable> void add(Item<T> var) {
        this.regs.add(var);
    }

    public void setParameterType(ParameterType type) {
        for (Item<ITsVariable> item : this.regs) {
            for (int i = 0; i < item.coefficients.length; ++i) {
                item.coefficients[i].setType(type);
            }
        }
    }

    public TsData data(TsDomain domain) {
        TsData sum = new TsData(domain, 0.0);
        for (Item<ITsVariable> item : this.regs) {
            if (!Parameter.isDefined(item.coefficients)) {
                return null;
            }
            int dim = item.variable.getDim();
            if (dim == 1) {
                double c = item.coefficients[0].getValue();
                if (c == 0.0) continue;
                DataBlock tmp = new DataBlock(domain.getLength());
                item.variable.data(domain, Collections.singletonList(tmp));
                sum.apply(tmp, (x, y) -> x + c * y);
                continue;
            }
            Matrix tmp = new Matrix(domain.getLength(), dim);
            List<DataBlock> cols = tmp.columnList();
            item.variable.data(domain, cols);
            int pos = 0;
            for (DataBlock col : cols) {
                double c;
                if ((c = item.coefficients[pos++].getValue()) == 0.0) continue;
                sum.apply(col, (x, y) -> x + c * y);
            }
        }
        return sum;
    }

    public static class Item<T extends ITsVariable> {
        public final T variable;
        public final Parameter[] coefficients;

        public Item(T variable, Parameter[] coeff) {
            if (coeff.length != variable.getDim()) {
                throw new IllegalArgumentException();
            }
            this.variable = variable;
            this.coefficients = coeff;
        }
    }
}

