/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.ucarima;

import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.RationalFunction;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.arima.SsfArima;
import ec.tstoolkit.ucarima.UcarimaModel;

public class SsfUcarima
implements ISsf {
    private UcarimaModel m_ucm;
    private int m_ncmps;
    private int m_dim;
    private double[][] m_dif;
    private double[][] m_phi;
    private double[][] m_psi;
    private double[][] m_stacgf;
    private double[][] m_stpsi;
    private double[] m_var;
    private double[] m_rtmp;
    private double[] m_ctmp;
    private int[] m_r;
    private DataBlock[] m_Phi;

    public SsfUcarima() {
    }

    public SsfUcarima(UcarimaModel ucm) {
        this.m_ucm = ucm;
        this.initModel();
    }

    private void _tvt(int r, int c, SubMatrix v) {
        int nr = this.m_r[r];
        int nc = this.m_r[c];
        double[] rphi = this.m_phi[r];
        double[] cphi = this.m_phi[c];
        DataBlock rtmp = new DataBlock(this.m_rtmp, 0, nc, 1);
        DataBlock ctmp = new DataBlock(this.m_ctmp, 0, nr, 1);
        rtmp.set(0.0);
        ctmp.set(0.0);
        DataBlockIterator cols = v.columns();
        DataBlock col = cols.getData();
        cols.end();
        for (int p = 1; p < cphi.length; ++p) {
            ctmp.addAY(-cphi[p], col);
            cols.previous();
        }
        DataBlockIterator rows = v.rows();
        DataBlock row = rows.getData();
        rows.end();
        for (int p = 1; p < rphi.length; ++p) {
            rtmp.addAY(-rphi[p], row);
            rows.previous();
        }
        double tlast = -this.m_Phi[c].dotReverse(rtmp);
        v.shift(-1);
        rtmp.bshift(DataBlock.ShiftOption.None);
        rtmp.set(nc - 1, tlast);
        ctmp.bshift(DataBlock.ShiftOption.None);
        ctmp.set(nr - 1, tlast);
        v.column(nc - 1).copy(ctmp);
        v.row(nr - 1).copy(rtmp);
    }

    private void _tvt(int cmp, SubMatrix v) {
        int n = this.m_r[cmp];
        double[] phi = this.m_phi[cmp];
        DataBlock tmp = new DataBlock(this.m_rtmp, 0, n, 1);
        tmp.set(0.0);
        DataBlockIterator cols = v.columns();
        DataBlock col = cols.getData();
        cols.end();
        for (int p = 1; p < phi.length; ++p) {
            tmp.addAY(-phi[p], col);
            cols.previous();
        }
        double tlast = -this.m_Phi[cmp].dotReverse(tmp);
        v.shift(-1);
        tmp.bshift(DataBlock.ShiftOption.None);
        tmp.set(n - 1, tlast);
        v.column(n - 1).copy(tmp);
        v.row(n - 1).copy(tmp);
    }

    public int cmpPos(int cmp) {
        if (cmp >= this.m_ucm.getComponentsCount() || this.m_ucm.getComponent(cmp).isNull()) {
            return -1;
        }
        int pos = 0;
        int j = 0;
        for (int i = 0; i < cmp; ++i) {
            if (this.m_ucm.getComponent(i).isNull()) continue;
            pos += this.m_r[j++];
        }
        return pos;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        int s = 0;
        int t = 0;
        for (int c = 0; c < this.m_ncmps; ++c) {
            int dim = this.m_r[c];
            int d = this.m_dif[c].length - 1;
            if (d > 0) {
                SsfArima.B0(b.extract(s, s + dim, t, t + d), this.m_dif[c]);
                t += d;
            }
            s += dim;
        }
    }

    private int DTot() {
        int nd = 0;
        for (int i = 0; i < this.m_ncmps; ++i) {
            nd += this.m_dif[i].length - 1;
        }
        return nd;
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        int s = 0;
        for (int cmp = 0; cmp < this.m_ncmps; ++cmp) {
            int dim = this.m_r[cmp];
            for (int i = 0; i < dim; ++i) {
                for (int j = 0; j <= i; ++j) {
                    qm.set(s + i, s + j, this.m_psi[cmp][i] * this.m_psi[cmp][j] * this.m_var[cmp]);
                }
            }
            s += dim;
        }
        SymmetricMatrix.fromLower(qm);
    }

    @Override
    public int getNonStationaryDim() {
        return this.DTot();
    }

    @Override
    public int getStateDim() {
        return this.m_dim;
    }

    @Override
    public int getTransitionResCount() {
        return this.m_dim;
    }

    @Override
    public int getTransitionResDim() {
        return this.m_ncmps;
    }

    public UcarimaModel getUCModel() {
        return this.m_ucm;
    }

    public double H(int pos) {
        return 0.0;
    }

    public boolean hasH() {
        return false;
    }

    @Override
    public boolean hasR() {
        return false;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return true;
    }

    private void initModel() {
        int i;
        this.m_ncmps = 0;
        this.m_dim = 0;
        for (i = 0; i < this.m_ucm.getComponentsCount(); ++i) {
            if (this.m_ucm.getComponent(i).isNull()) continue;
            ++this.m_ncmps;
        }
        this.m_dif = new double[this.m_ncmps][];
        this.m_phi = new double[this.m_ncmps][];
        this.m_Phi = new DataBlock[this.m_ncmps];
        this.m_psi = new double[this.m_ncmps][];
        this.m_r = new int[this.m_ncmps];
        this.m_stacgf = new double[this.m_ncmps][];
        this.m_stpsi = new double[this.m_ncmps][];
        this.m_var = new double[this.m_ncmps];
        int j = 0;
        for (i = 0; i < this.m_ucm.getComponentsCount(); ++i) {
            if (this.m_ucm.getComponent(i).isNull()) continue;
            this.initModel(j++, i);
        }
        this.m_rtmp = new double[this.m_dim];
        this.m_ctmp = new double[this.m_dim];
    }

    private void initModel(int i, int cmp) {
        ArimaModel model = this.m_ucm.getComponent(cmp);
        this.m_var[i] = model.getInnovationVariance();
        this.m_dif[i] = model.getNonStationaryAR().getCoefficients();
        Polynomial phi = model.getAR().getPolynomial();
        this.m_phi[i] = phi.getCoefficients();
        this.m_Phi[i] = new DataBlock(this.m_phi[i], 1, this.m_phi[i].length, 1);
        Polynomial theta = model.getMA().getPolynomial();
        this.m_r[i] = Math.max(phi.getDegree(), theta.getDegree() + 1);
        this.m_dim += this.m_r[i];
        this.m_psi[i] = new RationalFunction(theta, phi).coefficients(this.m_r[i]);
        Polynomial stphi = model.getStationaryAR().getPolynomial();
        this.m_stacgf[i] = new AutoCovarianceFunction(theta, stphi, this.m_var[i]).values(this.m_r[i]);
        this.m_stpsi[i] = new RationalFunction(theta, stphi).coefficients(this.m_r[i]);
    }

    @Override
    public boolean isDiffuse() {
        return this.DTot() > 0;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.m_ucm != null;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        this.T(pos, lm);
        int c = 0;
        for (int cmp = 0; cmp < this.m_ncmps; ++cmp) {
            lm.column(c).sub(k);
            c += this.m_r[cmp];
        }
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        int s = 0;
        for (int c = 0; c < this.m_ncmps; ++c) {
            int dim = this.m_r[c];
            Matrix stV = new Matrix(dim, dim);
            SsfArima.stVar(stV.subMatrix(), this.m_stpsi[c], this.m_stacgf[c], this.m_var[c]);
            Matrix K = new Matrix(dim, dim);
            SsfArima.Ksi(K.subMatrix(), this.m_dif[c]);
            SymmetricMatrix.quadraticFormT(stV.subMatrix(), K.subMatrix(), pf0.extract(s, s + dim, s, s + dim));
            s += dim;
        }
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        Matrix B = new Matrix(this.m_dim, this.DTot());
        int s = 0;
        int t = 0;
        for (int c = 0; c < this.m_ncmps; ++c) {
            int dim = this.m_r[c];
            int d = this.m_dif[c].length - 1;
            if (d > 0) {
                SsfArima.B0(B.subMatrix(s, s + dim, t, t + d), this.m_dif[c]);
                t += d;
            }
            s += dim;
        }
        SymmetricMatrix.XXt(B.subMatrix(), pi0);
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        qm.diagonal().copyFrom(this.m_var, 0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        int s = 0;
        for (int cmp = 0; cmp < this.m_ncmps; ++cmp) {
            int n = this.m_r[cmp];
            int sn = s + n;
            for (int i = 1; i < n; ++i) {
                tr.set(s + i - 1, s + i, 1.0);
            }
            double[] phi = this.m_phi[cmp];
            for (int i = 1; i < phi.length; ++i) {
                tr.set(sn - 1, sn - i, -phi[i]);
            }
            s += n;
        }
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        int i = 0;
        for (int r = 0; r < this.m_ncmps; ++r) {
            int rn = this.m_r[r];
            this._tvt(r, vm.extract(i, i + rn, i, i + rn));
            int j = 0;
            for (int c = 0; c < r; ++c) {
                int cn = this.m_r[c];
                SubMatrix u = vm.extract(i, i + rn, j, j + cn);
                this._tvt(r, c, u);
                SubMatrix v = vm.extract(j, j + cn, i, i + rn);
                v.copy(u.transpose());
                j += cn;
            }
            i += rn;
        }
    }

    @Override
    public void TX(int pos, DataBlock x) {
        int s = 0;
        for (int c = 0; c < this.m_ncmps; ++c) {
            int n = this.m_r[c];
            DataBlock xc = x.range(s, s + n);
            double last = this.m_Phi[c].dotReverse(xc);
            xc.bshift(DataBlock.ShiftOption.None);
            xc.set(n - 1, -last);
            s += n;
        }
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        int r = 0;
        for (int rcmp = 0; rcmp < this.m_ncmps; ++rcmp) {
            int c = 0;
            for (int ccmp = 0; ccmp <= rcmp; ++ccmp) {
                vm.add(r, c, d);
                if (r != c) {
                    vm.add(c, r, d);
                }
                c += this.m_r[ccmp];
            }
            r += this.m_r[rcmp];
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        int j = 0;
        for (int i = 0; i < this.m_ncmps; ++i) {
            int n = this.m_r[i];
            wv.column(i).range(j, j + n).copyFrom(this.m_psi[i], 0);
            j += n;
        }
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        int s = 0;
        for (int cmp = 0; cmp < this.m_ncmps; ++cmp) {
            x.add(s, d);
            s += this.m_r[cmp];
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        int s = 0;
        for (int c = 0; c < this.m_ncmps; ++c) {
            int n = this.m_r[c];
            DataBlock xc = x.range(s, s + n);
            double last = -xc.get(n - 1);
            xc.fshift(DataBlock.ShiftOption.None);
            xc.set(0, 0.0);
            if (last != 0.0) {
                for (int i = 1; i < this.m_phi[c].length; ++i) {
                    if (this.m_phi[c][i] == 0.0) continue;
                    xc.add(n - i, last * this.m_phi[c][i]);
                }
            }
            s += n;
        }
    }

    @Override
    public void Z(int pos, DataBlock x) {
        int s = 0;
        for (int cmp = 0; cmp < this.m_ncmps; ++cmp) {
            x.set(s, 1.0);
            s += this.m_r[cmp];
        }
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        x.copy(m.row(0));
        int c = this.m_r[0];
        for (int i = 1; i < this.m_ncmps; ++i) {
            x.add(m.row(c));
            c += this.m_r[i];
        }
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        double z = 0.0;
        int r = 0;
        for (int i = 0; i < this.m_ncmps; ++i) {
            z += vm.get(r, r);
            double w = 0.0;
            int c = 0;
            for (int j = 0; j < i; ++j) {
                w += vm.get(r, c);
                c += this.m_r[j];
            }
            z += 2.0 * w;
            r += this.m_r[i];
        }
        return z;
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        double r = 0.0;
        int c = 0;
        for (int i = 0; i < this.m_ncmps; ++i) {
            r += x.get(c);
            c += this.m_r[i];
        }
        return r;
    }
}

