/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.IRegressionTest;

public class DerivedRegressionTest
implements IRegressionTest {
    private double t_;
    private double vcur_;
    private double tcur_;

    public DerivedRegressionTest(double tsig) {
        this.t_ = tsig;
    }

    public double getValue() {
        return this.vcur_;
    }

    public double getTStat() {
        return this.t_;
    }

    @Override
    public boolean accept(ConcentratedLikelihood ll, int nhp, int ireg, int nregs, InformationSet info) {
        this.vcur_ = -new DataBlock(ll.getB(), ireg, ireg + nregs, 1).sum();
        double v = ll.getBVar(nhp >= 0, nhp).subMatrix(ireg, ireg + nregs, ireg, ireg + nregs).sum();
        this.tcur_ = this.vcur_ / Math.sqrt(v);
        return Math.abs(this.tcur_) > this.t_;
    }
}

