/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.sa;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.algorithm.implementation.TramoSeatsProcessingFactory;
import ec.satoolkit.algorithm.implementation.X13ProcessingFactory;
import ec.satoolkit.diagnostics.QSTest;
import ec.satoolkit.seats.SeatsResults;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.satoolkit.x11.X11Results;
import ec.satoolkit.x13.X13Specification;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.information.StatisticalTest;
import ec.tstoolkit.jdr.sa.SaDiagnostics;
import ec.tstoolkit.jdr.sa.TramoSeatsResults;
import ec.tstoolkit.jdr.sa.X13Results;
import ec.tstoolkit.modelling.DifferencingResults;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.RegressionUtilities;
import ec.tstoolkit.timeseries.regression.SeasonalDummies;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.List;
import jdr.spec.ts.Utility;

public final class Processor {
    private static final double E_LIMIT1 = 0.01;
    private static final double E_LIMIT2 = 0.005;
    static final int NY = 8;

    public static TramoSeatsResults tramoseats(TsData s, TramoSeatsSpecification spec, Utility.Dictionary dic) {
        ProcessingContext context = null;
        if (dic != null) {
            context = dic.toContext();
        }
        return Processor.tramoseatsWithContext(s, spec, context);
    }

    public static TramoSeatsResults tramoseatsWithContext(TsData s, TramoSeatsSpecification spec, ProcessingContext context) {
        s = s.cleanExtremities();
        CompositeResults rslts = TramoSeatsProcessingFactory.process((TsData)s, (TramoSeatsSpecification)spec, (ProcessingContext)context);
        PreprocessingModel regarima = (PreprocessingModel)rslts.get("preprocessing");
        SeatsResults seats = (SeatsResults)rslts.get("decomposition", SeatsResults.class);
        ISeriesDecomposition finals = (ISeriesDecomposition)rslts.get("final");
        SaDiagnostics diags = SaDiagnostics.of(regarima, (ISaResults)seats, finals);
        return new TramoSeatsResults(rslts, diags);
    }

    public static X13Results x13(TsData s, X13Specification spec, Utility.Dictionary dic) {
        ProcessingContext context = null;
        if (dic != null) {
            context = dic.toContext();
        }
        return Processor.x13WithContext(s, spec, context);
    }

    public static X13Results x13WithContext(TsData s, X13Specification spec, ProcessingContext context) {
        s = s.cleanExtremities();
        CompositeResults rslts = X13ProcessingFactory.process((TsData)s, (X13Specification)spec, (ProcessingContext)context);
        PreprocessingModel regarima = (PreprocessingModel)rslts.get("preprocessing");
        X11Results x11 = (X11Results)rslts.get("decomposition", X11Results.class);
        ISeriesDecomposition finals = (ISeriesDecomposition)rslts.get("final");
        SaDiagnostics diags = SaDiagnostics.of(regarima, (ISaResults)x11, finals);
        return new X13Results(rslts, diags);
    }

    private static StatisticalTest qs(TsData s, boolean mul) {
        if (s == null) {
            return null;
        }
        TsData sac = s;
        if (mul) {
            sac = sac.log();
        }
        int ifreq = sac.getFrequency().intValue();
        DifferencingResults dsa = DifferencingResults.create((TsData)sac, (int)-1, (boolean)true);
        return StatisticalTest.create((ec.tstoolkit.stats.StatisticalTest)QSTest.compute((double[])dsa.getDifferenced().internalStorage(), (int)ifreq, (int)2));
    }

    private static StatisticalTest f(TsData s, boolean mul) {
        if (s == null) {
            return null;
        }
        TsData sac = s;
        if (mul) {
            sac = sac.log();
        }
        int ifreq = sac.getFrequency().intValue();
        TsData salast = sac;
        salast = sac.drop(Math.max(0, sac.getLength() - ifreq * 8 - 1), 0);
        return StatisticalTest.create((ec.tstoolkit.stats.StatisticalTest)Processor.processAr(salast));
    }

    private static boolean isMultiplicative(CompositeResults rslts) {
        DecompositionMode mul = (DecompositionMode)rslts.getData("mode", DecompositionMode.class);
        return mul != null && mul.isMultiplicative();
    }

    private static boolean isSignificant(TsData i) {
        if (i == null) {
            return false;
        }
        DescriptiveStatistics idesc = new DescriptiveStatistics((IReadDataBlock)i);
        double se = idesc.getStdev();
        return se > 0.01;
    }

    private static boolean isSignificant(TsData s, TsData ref, double limit) {
        DescriptiveStatistics sdesc = new DescriptiveStatistics((IReadDataBlock)s);
        DescriptiveStatistics refdesc = new DescriptiveStatistics((IReadDataBlock)ref);
        double se = sdesc.getStdev();
        double refe = refdesc.getRmse();
        return refe == 0.0 || se / refe > limit;
    }

    private static ec.tstoolkit.stats.StatisticalTest processAr(TsData s) {
        try {
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock((IReadDataBlock)s);
            reg.setY(y.drop(1, 0));
            TsDomain edomain = s.getDomain().drop(1, 0);
            SeasonalDummies dummies = new SeasonalDummies(edomain.getFrequency());
            List regs = RegressionUtilities.data((ITsVariable)dummies, (TsDomain)edomain);
            reg.addX(y.drop(0, 1));
            for (DataBlock r : regs) {
                reg.addX(r);
            }
            reg.setMeanCorrection(true);
            int nseas = dummies.getDim();
            Ols ols = new Ols();
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 2, nseas, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }

    private Processor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

