/*
 * Decompiled with CFR 0.152.
 */
package demetra.xml;

import demetra.datatypes.Ts;
import demetra.datatypes.TsInformationType;
import demetra.datatypes.TsMoniker;
import demetra.xml.IXmlConverter;
import demetra.xml.XmlMetaData;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="ts")
@XmlType(name="tsType")
public class XmlTs
implements IXmlConverter<Ts> {
    static final String NAME = "tsType";
    static final String RNAME = "ts";
    @XmlElement
    public Integer freq;
    @XmlElement
    public Integer firstYear;
    @XmlElement
    public Integer firstPeriod;
    @XmlElement(name="data")
    @XmlList
    public double[] data;
    @XmlElement
    public XmlMetaData metaData;
    @XmlAttribute
    public String name;
    @XmlAttribute
    public String source;
    @XmlAttribute
    public String identifier;

    @Override
    public void copy(Ts t) {
        TsData tsdata = t.getData();
        if (tsdata != null) {
            TsPeriod start = tsdata.getStart();
            this.freq = start.getFrequency().intValue();
            this.firstYear = start.getYear();
            this.firstPeriod = start.getPosition() + 1;
            this.data = tsdata.internalStorage();
        }
        this.source = t.getMoniker().getSource();
        this.identifier = t.getMoniker().getId();
        this.name = t.getName();
        if (!t.getMetaData().isEmpty()) {
            this.metaData = new XmlMetaData();
            this.metaData.copy(t.getMetaData());
        }
    }

    @Override
    public Ts create() {
        TsMoniker moniker = TsMoniker.create(this.source, this.identifier);
        return Ts.builder().moniker(moniker).name(this.name).metaData((Map<? extends String, ? extends String>)(this.metaData == null ? Collections.EMPTY_MAP : this.metaData.create())).type(this.data != null ? TsInformationType.UserDefined : TsInformationType.None).data(this.data != null ? new TsData(TsFrequency.valueOf((int)this.freq), this.firstYear.intValue(), this.firstPeriod - 1, this.data, false) : null).build();
    }
}

