% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_workspace.R
\name{get_ts}
\alias{get_ts}
\title{Get the input raw time series}
\usage{
get_ts(x)
}
\arguments{
\item{x}{the object where to get the time series.}
}
\value{
\code{get_ts()} returns a \code{\link[stats]{ts}} object or list of \code{\link[stats]{ts}} objects:
\itemize{
 \item if \code{x} is a \code{sa_item} or a \code{SA} object, \code{get_ts(x)} returns a single \code{ts} object;
 \item if \code{x} is a \code{multiprocessing} object, \code{get_ts(x)} returns list of length the number
 of sa_items, each a \code{ts} object;
 \item if \code{x} is a \code{workspace} object, \code{get_ts(x)} returns list of length the number of multiprocessing,
 each element containing a list of \code{ts} object.
}
}
\description{
Generics functions to get the input raw time series of a \code{workspace}, \code{multiprocessing},
\code{sa_item} or \code{SA} object.
}
\examples{
\donttest{
sa_x13 <- x13(ipi_c_eu[, "FR"], spec = "RSA5c")

wk <- new_workspace()
mp <- new_multiprocessing(wk, "sa1")
add_sa_item(wk, "sa1", sa_x13, "X13")
sa_item <- get_object(mp, 1)

  # Extracting from a SA:
get_ts(sa_x13) # Returns the ts object ipi_c_eu[, "FR"]

  # Extracting from a sa_item:
get_ts(sa_item) # Returns the ts object ipi_c_eu[, "FR"]

  # Extracting from a multiprocessing:
# Returns a list of length 1 named "X13" containing the ts object ipi_c_eu[, "FR"]:
get_ts(mp)


  # Extracting from a workspace:
# Returns a list of length 1 named "sa1" containing a list
# of length 1 named "X13" containing the ts object ipi_c_eu[, "FR"]
get_ts(wk)
}
}
\seealso{
Other functions to get informations from a workspace, multiprocessing or sa_item: \code{\link{count}},
  \code{\link{get_model}}, \code{\link{get_name}},
  \code{\link{get_object}}
}
\concept{functions to get informations from a workspace, multiprocessing or sa_item}
