/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.simplets;

import ec.tstoolkit.data.AbsMeanNormalizer;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public abstract class AbstractTsBenchmarking {
    private TsAggregationType type_ = TsAggregationType.Sum;
    private double eps_ = 1.0E-9;

    protected abstract TsData benchmark(TsData var1, TsData var2);

    protected boolean checkConstraints(TsData s, TsData constraints) {
        TsData del = constraints.minus(s.changeFrequency(constraints.getFrequency(), this.type_, true));
        DescriptiveStatistics stats = new DescriptiveStatistics(del);
        return stats.isZero(this.eps_ * stats.getStdev());
    }

    protected TsData checkFrequencies(TsData s, TsData constraints) {
        int lfreq = constraints.getFrequency().intValue();
        int hfreq = s.getFrequency().intValue();
        if (hfreq == lfreq) {
            return constraints;
        }
        if (hfreq % lfreq == 0) {
            return null;
        }
        throw new TsException("Incompatible frequencies");
    }

    public static double[] expand(TsDomain d, TsData agg, TsAggregationType type) {
        int hfreq = d.getFrequency().intValue();
        int lfreq = agg.getFrequency().intValue();
        int c = hfreq / lfreq;
        double[] y = new double[d.getLength()];
        for (int i = 0; i < y.length; ++i) {
            y[i] = Double.NaN;
        }
        TsPeriod aggstart = agg.getStart();
        int fpos = type == TsAggregationType.First ? aggstart.getPosition() : aggstart.getPosition() * c + c - 1;
        TsPeriod first = new TsPeriod(d.getFrequency(), aggstart.getYear(), fpos);
        int pos = d.search(first);
        if (pos < 0) {
            return null;
        }
        int p = 0;
        while (p < agg.getLength()) {
            y[pos] = agg.get(p++);
            pos += c;
        }
        return y;
    }

    public TsAggregationType getAggregationType() {
        return this.type_;
    }

    public double getEpsilon() {
        return this.eps_;
    }

    public TsData process(TsData s, TsData constraints) {
        TsData r = this.checkFrequencies(s, constraints);
        if (r != null) {
            return null;
        }
        if (this.checkConstraints(s, constraints)) {
            return s;
        }
        AbsMeanNormalizer normalizer = new AbsMeanNormalizer();
        if (normalizer.process(s)) {
            TsData tmp = new TsData(s.getStart(), normalizer.getNormalizedData(), false);
            TsData btmp = this.benchmark(tmp, constraints.times(normalizer.getFactor()));
            if (btmp != null) {
                btmp.apply(x -> x / normalizer.getFactor());
            }
            return btmp;
        }
        return this.benchmark(s, constraints);
    }

    public void setAggregationType(TsAggregationType value) {
        this.type_ = value;
    }

    public void setEpsilon(double value) {
        this.eps_ = value;
    }
}

