/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace.io;

import demetra.workspace.io.IO;
import demetra.workspace.io.Xml;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.NonNull;

public final class Stax {
    public static void preventXXE(@Nonnull XMLInputFactory factory) {
        Stax.setFeature(factory, "javax.xml.stream.supportDTD", false);
        Stax.setFeature(factory, "javax.xml.stream.isSupportingExternalEntities", false);
    }

    private static void setFeature(XMLInputFactory factory, String feature, boolean value) {
        if (factory.isPropertySupported(feature) && (Boolean)factory.getProperty(feature) != value) {
            factory.setProperty(feature, value);
        }
    }

    private Stax() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    private static interface XSupplier<T> {
        public T create(XMLInputFactory var1) throws XMLStreamException;
    }

    public static final class EventParser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final FlowHandler<XMLEventReader, T> handler;
        @NonNull
        private final IO.Supplier<? extends XMLInputFactory> factory;
        private boolean preventXXE;

        @Nonnull
        public static <T> EventParser<T> flowOf(@Nonnull FlowHandler<XMLEventReader, T> handler) {
            return EventParser.builder().handler(handler).build();
        }

        @Nonnull
        public static <T> EventParser<T> valueOf(@Nonnull ValueHandler<XMLEventReader, T> handler) {
            return EventParser.builder().handler(handler.asFlow()).build();
        }

        @Override
        public T parseReader(IO.Supplier<? extends Reader> source) throws IOException {
            Reader resource = source.getWithIO();
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), (Closeable)resource);
        }

        @Override
        public T parseStream(IO.Supplier<? extends InputStream> source) throws IOException {
            InputStream resource = source.getWithIO();
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), (Closeable)resource);
        }

        @Override
        public T parseReader(Reader resource) throws IOException {
            Objects.requireNonNull(resource);
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), IO.Runnable.noOp().asCloseable());
        }

        @Override
        public T parseStream(InputStream resource) throws IOException {
            Objects.requireNonNull(resource);
            return this.parse((XMLInputFactory o) -> o.createXMLEventReader(resource), IO.Runnable.noOp().asCloseable());
        }

        private T parse(XSupplier<XMLEventReader> supplier, Closeable onClose) throws IOException {
            try {
                XMLEventReader input = supplier.create(this.getEngine());
                return this.parse(input, () -> EventParser.closeBoth(input, onClose));
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (IOException | Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
        }

        private T parse(XMLEventReader input, Closeable onClose) throws IOException {
            try {
                return this.handler.parse(input, onClose);
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (IOException | Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
        }

        private XMLInputFactory getEngine() throws IOException {
            XMLInputFactory result = this.factory.getWithIO();
            if (this.preventXXE) {
                Stax.preventXXE(result);
            }
            return result;
        }

        private static void closeBoth(XMLEventReader input, Closeable onClose) throws IOException {
            try {
                input.close();
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
            onClose.close();
        }

        private static <T> IO.Supplier<? extends XMLInputFactory> $default$factory() {
            return XMLInputFactory::newFactory;
        }

        private static <T> boolean $default$preventXXE() {
            return true;
        }

        EventParser(@NonNull FlowHandler<XMLEventReader, T> handler, @NonNull IO.Supplier<? extends XMLInputFactory> factory, boolean preventXXE) {
            if (handler == null) {
                throw new NullPointerException("handler is marked @NonNull but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked @NonNull but is null");
            }
            this.handler = handler;
            this.factory = factory;
            this.preventXXE = preventXXE;
        }

        public static <T> Builder<T> builder() {
            return new Builder();
        }

        public Builder<T> toBuilder() {
            return new Builder<T>().handler(this.handler).factory(this.factory).preventXXE(this.preventXXE);
        }

        public static class Builder<T> {
            private FlowHandler<XMLEventReader, T> handler;
            private boolean factory$set;
            private IO.Supplier<? extends XMLInputFactory> factory;
            private boolean preventXXE$set;
            private boolean preventXXE;

            Builder() {
            }

            public Builder<T> handler(@NonNull FlowHandler<XMLEventReader, T> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is marked @NonNull but is null");
                }
                this.handler = handler;
                return this;
            }

            public Builder<T> factory(@NonNull IO.Supplier<? extends XMLInputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked @NonNull but is null");
                }
                this.factory = factory;
                this.factory$set = true;
                return this;
            }

            public Builder<T> preventXXE(boolean preventXXE) {
                this.preventXXE = preventXXE;
                this.preventXXE$set = true;
                return this;
            }

            public EventParser<T> build() {
                IO.Supplier factory = this.factory;
                if (!this.factory$set) {
                    factory = EventParser.$default$factory();
                }
                boolean preventXXE = this.preventXXE;
                if (!this.preventXXE$set) {
                    preventXXE = EventParser.$default$preventXXE();
                }
                return new EventParser<T>(this.handler, factory, preventXXE);
            }

            public String toString() {
                return "Stax.EventParser.Builder(handler=" + this.handler + ", factory=" + this.factory + ", preventXXE=" + this.preventXXE + ")";
            }
        }
    }

    public static final class StreamParser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final FlowHandler<XMLStreamReader, T> handler;
        @NonNull
        private final IO.Supplier<? extends XMLInputFactory> factory;
        private boolean preventXXE;

        @Nonnull
        public static <T> StreamParser<T> flowOf(@Nonnull FlowHandler<XMLStreamReader, T> handler) {
            return StreamParser.builder().handler(handler).build();
        }

        @Nonnull
        public static <T> StreamParser<T> valueOf(@Nonnull ValueHandler<XMLStreamReader, T> handler) {
            return StreamParser.builder().handler(handler.asFlow()).build();
        }

        @Override
        public T parseReader(IO.Supplier<? extends Reader> source) throws IOException {
            Reader resource = source.getWithIO();
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), (Closeable)resource);
        }

        @Override
        public T parseStream(IO.Supplier<? extends InputStream> source) throws IOException {
            InputStream resource = source.getWithIO();
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), (Closeable)resource);
        }

        @Override
        public T parseReader(Reader resource) throws IOException {
            Objects.requireNonNull(resource);
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), IO.Runnable.noOp().asCloseable());
        }

        @Override
        public T parseStream(InputStream resource) throws IOException {
            Objects.requireNonNull(resource);
            return this.parse((XMLInputFactory o) -> o.createXMLStreamReader(resource), IO.Runnable.noOp().asCloseable());
        }

        @Nonnull
        public T parse(@Nonnull XMLStreamReader input, @Nonnull Closeable onClose) throws IOException {
            try {
                return this.handler.parse(input, onClose);
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (IOException | Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
        }

        private T parse(XSupplier<XMLStreamReader> supplier, Closeable onClose) throws IOException {
            try {
                XMLStreamReader input = supplier.create(this.getEngine());
                return this.parse(input, () -> StreamParser.closeBoth(input, onClose));
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (IOException | Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
        }

        private XMLInputFactory getEngine() throws IOException {
            XMLInputFactory result = this.factory.getWithIO();
            if (this.preventXXE) {
                Stax.preventXXE(result);
            }
            return result;
        }

        private static void closeBoth(XMLStreamReader input, Closeable onClose) throws IOException {
            try {
                input.close();
            }
            catch (XMLStreamException ex) {
                IO.ensureClosed(ex, onClose);
                throw new Xml.WrappedException(ex);
            }
            catch (Error | RuntimeException ex) {
                IO.ensureClosed(ex, onClose);
                throw ex;
            }
            onClose.close();
        }

        private static <T> IO.Supplier<? extends XMLInputFactory> $default$factory() {
            return XMLInputFactory::newFactory;
        }

        private static <T> boolean $default$preventXXE() {
            return true;
        }

        StreamParser(@NonNull FlowHandler<XMLStreamReader, T> handler, @NonNull IO.Supplier<? extends XMLInputFactory> factory, boolean preventXXE) {
            if (handler == null) {
                throw new NullPointerException("handler is marked @NonNull but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked @NonNull but is null");
            }
            this.handler = handler;
            this.factory = factory;
            this.preventXXE = preventXXE;
        }

        public static <T> Builder<T> builder() {
            return new Builder();
        }

        public Builder<T> toBuilder() {
            return new Builder<T>().handler(this.handler).factory(this.factory).preventXXE(this.preventXXE);
        }

        public static class Builder<T> {
            private FlowHandler<XMLStreamReader, T> handler;
            private boolean factory$set;
            private IO.Supplier<? extends XMLInputFactory> factory;
            private boolean preventXXE$set;
            private boolean preventXXE;

            Builder() {
            }

            public Builder<T> handler(@NonNull FlowHandler<XMLStreamReader, T> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is marked @NonNull but is null");
                }
                this.handler = handler;
                return this;
            }

            public Builder<T> factory(@NonNull IO.Supplier<? extends XMLInputFactory> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked @NonNull but is null");
                }
                this.factory = factory;
                this.factory$set = true;
                return this;
            }

            public Builder<T> preventXXE(boolean preventXXE) {
                this.preventXXE = preventXXE;
                this.preventXXE$set = true;
                return this;
            }

            public StreamParser<T> build() {
                IO.Supplier factory = this.factory;
                if (!this.factory$set) {
                    factory = StreamParser.$default$factory();
                }
                boolean preventXXE = this.preventXXE;
                if (!this.preventXXE$set) {
                    preventXXE = StreamParser.$default$preventXXE();
                }
                return new StreamParser<T>(this.handler, factory, preventXXE);
            }

            public String toString() {
                return "Stax.StreamParser.Builder(handler=" + this.handler + ", factory=" + this.factory + ", preventXXE=" + this.preventXXE + ")";
            }
        }
    }

    @FunctionalInterface
    public static interface ValueHandler<I, T> {
        @Nonnull
        public T parse(@Nonnull I var1) throws XMLStreamException;

        @Nonnull
        default public FlowHandler<I, T> asFlow() {
            return (input, onClose) -> {
                try (Closeable c = onClose;){
                    T t = this.parse(input);
                    return t;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface FlowHandler<I, T> {
        @Nonnull
        public T parse(@Nonnull I var1, @Nonnull Closeable var2) throws IOException, XMLStreamException;

        @Nonnull
        public static <I, T> FlowHandler<I, T> of(@Nonnull ValueHandler<I, T> handler) {
            return handler.asFlow();
        }
    }
}

