% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utils.R
\name{switch_colors}
\alias{switch_colors}
\title{Swap Colors in an Image}
\usage{
switch_colors(target_image, source_image, source_colors = 3,
  smoothness = 100, ...)
}
\arguments{
\item{target_image}{Matrix The image you wish to transfer colors into.
The output from \code{readJPEG} is of suitable format.}

\item{source_image}{Matrix The image you wish to transfer colors from.}

\item{source_colors}{Integer The number of colors you wish to extract from the
source image.}

\item{smoothness}{Integer The source colors are interpolated such that the image
doesn't appear blocky. The value of smoothness determines how many values are interpoloated
between the source_colors. That is, smoothness determines the length of the palette used.
Higher values return smoother images.}

\item{...}{Pass any of the arguments for \code{image_palette}}
}
\value{
The image, but with swapped colors!
}
\description{
Swap the palette of an image!
}
\examples{
#Trivial example of using only 5 dominant colors
# from an image to recolor itself
img1 <- jpeg::readJPEG(system.file("img", "Rlogo.jpg", package="jpeg"))
img2 <- jpeg::readJPEG(system.file("img", "Rlogo.jpg", package="jpeg"))
switch_colors(img1, img2, source_colors=5, smoothness=20)
}

