/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TextEncoder {
    private ImageProcessor ip;
    private Calibration cal;
    private int precision;

    public TextEncoder(ImageProcessor imageProcessor, Calibration calibration, int n) {
        this.ip = imageProcessor;
        this.cal = calibration;
        this.precision = n;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        boolean bl;
        PrintWriter printWriter = new PrintWriter(dataOutputStream);
        boolean bl2 = bl = this.cal != null && this.cal.calibrated();
        if (bl) {
            this.ip.setCalibrationTable(this.cal.getCTable());
        } else {
            this.ip.setCalibrationTable(null);
        }
        boolean bl3 = !bl && (this.ip instanceof ByteProcessor || this.ip instanceof ShortProcessor);
        int n = this.ip.getWidth();
        int n2 = this.ip.getHeight();
        int n3 = n2 / 20;
        if (n3 < 1) {
            n3 = 1;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = this.ip.getPixelValue(j, i);
                if (bl3) {
                    printWriter.print((int)d);
                } else {
                    printWriter.print(IJ.d2s(d, this.precision));
                }
                if (j == n - 1) continue;
                printWriter.print("\t");
            }
            printWriter.println();
            if (i % n3 != 0) continue;
            IJ.showProgress((double)i / (double)n2);
        }
        printWriter.close();
        IJ.showProgress(1.0);
    }
}

