/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.FHT;
import ij.process.ImageProcessor;

public class Undo {
    public static final int NOTHING = 0;
    public static final int FILTER = 1;
    public static final int TYPE_CONVERSION = 2;
    public static final int PASTE = 3;
    public static final int COMPOUND_FILTER = 4;
    public static final int COMPOUND_FILTER_DONE = 5;
    public static final int TRANSFORM = 6;
    public static final int OVERLAY_ADDITION = 7;
    private static int whatToUndo = 0;
    private static int imageID;
    private static ImageProcessor ipCopy;
    private static ImagePlus impCopy;
    private static Calibration calCopy;

    public static void setup(int n, ImagePlus imagePlus) {
        if (imagePlus == null) {
            whatToUndo = 0;
            Undo.reset();
            return;
        }
        if (n == 1 && whatToUndo == 4) {
            return;
        }
        if (n == 5) {
            if (whatToUndo == 4) {
                whatToUndo = n;
            }
            return;
        }
        whatToUndo = n;
        imageID = imagePlus.getID();
        if (n == 2) {
            ipCopy = imagePlus.getProcessor();
            calCopy = (Calibration)imagePlus.getCalibration().clone();
        } else if (n == 6) {
            impCopy = new ImagePlus(imagePlus.getTitle(), imagePlus.getProcessor().duplicate());
            Object object = imagePlus.getProperty("FHT");
            if (object != null) {
                object = new FHT((ImageProcessor)object);
                impCopy.setProperty("FHT", object);
            }
        } else if (n == 4) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            ipCopy = imageProcessor != null ? imageProcessor.duplicate() : null;
        } else if (n == 7) {
            impCopy = null;
            ipCopy = null;
        } else {
            ipCopy = null;
        }
    }

    public static void reset() {
        if (whatToUndo == 4 || whatToUndo == 7) {
            return;
        }
        whatToUndo = 0;
        imageID = 0;
        ipCopy = null;
        impCopy = null;
        calCopy = null;
    }

    public static void undo() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imageID != imagePlus.getID()) {
            Undo.reset();
            return;
        }
        switch (whatToUndo) {
            case 1: {
                ImageProcessor imageProcessor = imagePlus.getProcessor();
                if (imageProcessor == null) break;
                imageProcessor.reset();
                imagePlus.updateAndDraw();
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                if (ipCopy == null) break;
                if (whatToUndo == 2 && calCopy != null) {
                    imagePlus.setCalibration(calCopy);
                }
                imagePlus.setProcessor(null, ipCopy);
                break;
            }
            case 6: {
                if (impCopy == null) break;
                imagePlus.setProcessor(impCopy.getTitle(), impCopy.getProcessor());
                Object object = impCopy.getProperty("FHT");
                if (object != null) {
                    imagePlus.setProperty("FHT", object);
                    break;
                }
                if (imagePlus.getProperty("FHT") == null) break;
                imagePlus.getProperties().remove("FHT");
                break;
            }
            case 3: {
                Roi roi = imagePlus.getRoi();
                if (roi == null) break;
                roi.abortPaste();
                break;
            }
            case 7: {
                Overlay overlay = imagePlus.getOverlay();
                if (overlay == null) {
                    IJ.beep();
                    return;
                }
                int n = overlay.size();
                if (n <= 0) {
                    IJ.beep();
                    return;
                }
                overlay.remove(n - 1);
                imagePlus.draw();
                return;
            }
        }
        Undo.reset();
    }

    static {
        ipCopy = null;
    }
}

