/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Locale;

public class JpegWriter
implements PlugIn {
    public static final int DEFAULT_QUALITY = 75;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        imp.startTiming();
        this.saveAsJpeg(imp, arg);
        IJ.showTime(imp, imp.getStartTime(), "JpegWriter: ");
    }

    void saveAsJpeg(ImagePlus imp, String path) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        int quality = FileSaver.getJpegQuality();
        BufferedImage bi = new BufferedImage(width, height, 1);
        try {
            FileOutputStream f = new FileOutputStream(path);
            Graphics2D g = bi.createGraphics();
            g.drawImage(imp.getImage(), 0, 0, null);
            g.dispose();
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)f);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bi);
            if (quality == 100) {
                param.setQuality(1.0f, true);
                param.setHorizontalSubsampling(1, 1);
                param.setHorizontalSubsampling(2, 1);
                param.setVerticalSubsampling(1, 1);
                param.setVerticalSubsampling(2, 1);
            } else {
                float q = quality == 99 ? 1.0f : (float)((double)quality / 100.0);
                param.setQuality(q, true);
            }
            Calibration cal = imp.getCalibration();
            String unit = cal.getUnit().toLowerCase(Locale.US);
            if (cal.getUnit().equals("inch") || cal.getUnit().equals("in")) {
                param.setDensityUnit(1);
                param.setXDensity((int)Math.round(1.0 / cal.pixelWidth));
                param.setYDensity((int)Math.round(1.0 / cal.pixelHeight));
            }
            encoder.encode(bi, param);
            f.close();
        }
        catch (Exception e) {
            IJ.error("Jpeg Writer", "" + e);
        }
    }

    public static void setQuality(int jpegQuality) {
        FileSaver.setJpegQuality(jpegQuality);
    }

    public static int getQuality() {
        return FileSaver.getJpegQuality();
    }
}

