/*
 * Decompiled with CFR 0.152.
 */
package com.nexr.rhive.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.NetUtils;

public class DFUtils {
    private Configuration conf;

    public DFUtils(Configuration conf) throws Exception {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    private String getInfoServer() throws IOException {
        return NetUtils.getServerAddress((Configuration)this.getConf(), (String)"dfs.info.bindAddress", (String)"dfs.info.port", (String)"dfs.http.address");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFileInfo(String dir) throws Exception {
        String fsName = this.getInfoServer();
        StringBuffer url = new StringBuffer("http://" + fsName + "/fsck?path=");
        Path hdfs = new Path(dir);
        dir = hdfs.toUri().getPath();
        url.append(URLEncoder.encode(dir, "UTF-8"));
        URL path = new URL(url.toString());
        URLConnection connection = path.openConnection();
        InputStream stream = connection.getInputStream();
        BufferedReader input = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        String line = null;
        ArrayList<String> metas = new ArrayList<String>();
        try {
            while ((line = input.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(line, "\t");
                if (tokens.countTokens() != 2) continue;
                String key = tokens.nextToken();
                if (key.trim().startsWith("Total blocks")) {
                    StringTokenizer _tokens = new StringTokenizer(tokens.nextToken(), " ");
                    metas.add(_tokens.nextToken());
                    continue;
                }
                metas.add(tokens.nextToken());
            }
        }
        finally {
            input.close();
        }
        return metas.toArray(new String[0]);
    }
}

