/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;

public class CombineFileRecordReader<K, V>
extends RecordReader<K, V> {
    static final Class[] constructorSignature = new Class[]{CombineFileSplit.class, TaskAttemptContext.class, Integer.class};
    protected CombineFileSplit split;
    protected Class<? extends RecordReader<K, V>> rrClass;
    protected Constructor<? extends RecordReader<K, V>> rrConstructor;
    protected FileSystem fs;
    protected TaskAttemptContext context;
    protected int idx;
    protected long progress;
    protected RecordReader<K, V> curReader;

    @Override
    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.split = (CombineFileSplit)split;
        this.context = context;
        if (null != this.curReader) {
            this.curReader.initialize(split, context);
        }
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.curReader == null || !this.curReader.nextKeyValue()) {
            if (this.initNextRecordReader()) continue;
            return false;
        }
        return true;
    }

    @Override
    public K getCurrentKey() throws IOException, InterruptedException {
        return this.curReader.getCurrentKey();
    }

    @Override
    public V getCurrentValue() throws IOException, InterruptedException {
        return this.curReader.getCurrentValue();
    }

    @Override
    public void close() throws IOException {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
        }
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        long subprogress = 0L;
        if (null != this.curReader) {
            subprogress = (long)(this.curReader.getProgress() * (float)this.split.getLength(this.idx - 1));
        }
        return Math.min(1.0f, (float)(this.progress + subprogress) / (float)this.split.getLength());
    }

    public CombineFileRecordReader(CombineFileSplit split, TaskAttemptContext context, Class<? extends RecordReader<K, V>> rrClass) throws IOException {
        this.split = split;
        this.context = context;
        this.rrClass = rrClass;
        this.idx = 0;
        this.curReader = null;
        this.progress = 0L;
        try {
            this.rrConstructor = rrClass.getDeclaredConstructor(constructorSignature);
            this.rrConstructor.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(rrClass.getName() + " does not have valid constructor", e);
        }
        this.initNextRecordReader();
    }

    protected boolean initNextRecordReader() throws IOException {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
            if (this.idx > 0) {
                this.progress += this.split.getLength(this.idx - 1);
            }
        }
        if (this.idx == this.split.getNumPaths()) {
            return false;
        }
        try {
            this.curReader = this.rrConstructor.newInstance(this.split, this.context, this.idx);
            Configuration conf = this.context.getConfiguration();
            conf.set("map.input.file", this.split.getPath(this.idx).toString());
            conf.setLong("map.input.start", this.split.getOffset(this.idx));
            conf.setLong("map.input.length", this.split.getLength(this.idx));
            this.curReader = this.rrConstructor.newInstance(this.split, this.context, this.idx);
            if (this.idx > 0) {
                this.curReader.initialize(this.split, this.context);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ++this.idx;
        return true;
    }
}

