/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class SequenceFileAsBinaryOutputFormat
extends SequenceFileOutputFormat<BytesWritable, BytesWritable> {
    public static void setSequenceFileOutputKeyClass(JobConf conf, Class<?> theClass) {
        conf.setClass("mapred.seqbinary.output.key.class", theClass, Object.class);
    }

    public static void setSequenceFileOutputValueClass(JobConf conf, Class<?> theClass) {
        conf.setClass("mapred.seqbinary.output.value.class", theClass, Object.class);
    }

    public static Class<? extends WritableComparable> getSequenceFileOutputKeyClass(JobConf conf) {
        return conf.getClass("mapred.seqbinary.output.key.class", conf.getOutputKeyClass().asSubclass(WritableComparable.class), WritableComparable.class);
    }

    public static Class<? extends Writable> getSequenceFileOutputValueClass(JobConf conf) {
        return conf.getClass("mapred.seqbinary.output.value.class", conf.getOutputValueClass().asSubclass(Writable.class), Writable.class);
    }

    @Override
    public RecordWriter<BytesWritable, BytesWritable> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path file = FileOutputFormat.getTaskOutputPath(job, name);
        FileSystem fs = file.getFileSystem(job);
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (SequenceFileAsBinaryOutputFormat.getCompressOutput(job)) {
            compressionType = SequenceFileAsBinaryOutputFormat.getOutputCompressionType(job);
            Class<CompressionCodec> codecClass = SequenceFileAsBinaryOutputFormat.getOutputCompressorClass(job, DefaultCodec.class);
            codec = ReflectionUtils.newInstance(codecClass, job);
        }
        final SequenceFile.Writer out = SequenceFile.createWriter(fs, job, file, SequenceFileAsBinaryOutputFormat.getSequenceFileOutputKeyClass(job), SequenceFileAsBinaryOutputFormat.getSequenceFileOutputValueClass(job), compressionType, codec, progress);
        return new RecordWriter<BytesWritable, BytesWritable>(){
            private WritableValueBytes wvaluebytes = new WritableValueBytes();

            @Override
            public void write(BytesWritable bkey, BytesWritable bvalue) throws IOException {
                this.wvaluebytes.reset(bvalue);
                out.appendRaw(bkey.getBytes(), 0, bkey.getLength(), this.wvaluebytes);
                this.wvaluebytes.reset(null);
            }

            @Override
            public void close(Reporter reporter) throws IOException {
                out.close();
            }
        };
    }

    @Override
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        super.checkOutputSpecs(ignored, job);
        if (SequenceFileAsBinaryOutputFormat.getCompressOutput(job) && SequenceFileAsBinaryOutputFormat.getOutputCompressionType(job) == SequenceFile.CompressionType.RECORD) {
            throw new InvalidJobConfException("SequenceFileAsBinaryOutputFormat doesn't support Record Compression");
        }
    }

    protected static class WritableValueBytes
    implements SequenceFile.ValueBytes {
        private BytesWritable value;

        public WritableValueBytes() {
            this.value = null;
        }

        public WritableValueBytes(BytesWritable value) {
            this.value = value;
        }

        public void reset(BytesWritable value) {
            this.value = value;
        }

        @Override
        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
            outStream.write(this.value.getBytes(), 0, this.value.getLength());
        }

        @Override
        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            throw new UnsupportedOperationException("WritableValueBytes doesn't support RECORD compression");
        }

        @Override
        public int getSize() {
            return this.value.getLength();
        }
    }
}

