/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.filecache.TaskDistributedCacheManager;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.DefaultTaskController;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.JobTrackerMetricsInst;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;

class LocalJobRunner
implements JobSubmissionProtocol {
    public static final Log LOG = LogFactory.getLog(LocalJobRunner.class);
    private FileSystem fs;
    private HashMap<JobID, Job> jobs = new HashMap();
    private JobConf conf;
    private int map_tasks = 0;
    private int reduce_tasks = 0;
    final Random rand = new Random();
    private JobTrackerInstrumentation myMetrics = null;
    private static final String jobDir = "localRunner/";
    private static int jobid = 0;

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) {
        return 26L;
    }

    public LocalJobRunner(JobConf conf) throws IOException {
        this.fs = FileSystem.getLocal(conf);
        this.conf = conf;
        this.myMetrics = new JobTrackerMetricsInst(null, new JobConf(conf));
    }

    @Override
    public synchronized JobID getNewJobId() {
        return new JobID("local", ++jobid);
    }

    @Override
    public JobStatus submitJob(JobID jobid, String jobSubmitDir, Credentials credentials) throws IOException {
        Job job = new Job(jobid, jobSubmitDir);
        job.job.setCredentials(credentials);
        return job.status;
    }

    @Override
    public void killJob(JobID id) {
        this.jobs.get((Object)id).killed = true;
        this.jobs.get(id).interrupt();
    }

    @Override
    public void setJobPriority(JobID id, String jp) throws IOException {
        throw new UnsupportedOperationException("Changing job priority in LocalJobRunner is not supported.");
    }

    @Override
    public boolean killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
        throw new UnsupportedOperationException("Killing tasks in LocalJobRunner is not supported");
    }

    @Override
    public JobProfile getJobProfile(JobID id) {
        Job job = this.jobs.get(id);
        if (job != null) {
            return job.getProfile();
        }
        return null;
    }

    @Override
    public TaskReport[] getMapTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public TaskReport[] getReduceTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public TaskReport[] getCleanupTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public TaskReport[] getSetupTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public JobStatus getJobStatus(JobID id) {
        Job job = this.jobs.get(id);
        if (job != null) {
            return job.status;
        }
        return null;
    }

    @Override
    public Counters getJobCounters(JobID id) {
        Job job = this.jobs.get(id);
        return job.currentCounters;
    }

    @Override
    public String getFilesystemName() throws IOException {
        return this.fs.getUri().toString();
    }

    @Override
    public ClusterStatus getClusterStatus(boolean detailed) {
        return new ClusterStatus(1, 0, 0L, this.map_tasks, this.reduce_tasks, 1, 1, JobTracker.State.RUNNING);
    }

    @Override
    public JobStatus[] jobsToComplete() {
        return null;
    }

    @Override
    public TaskCompletionEvent[] getTaskCompletionEvents(JobID jobid, int fromEventId, int maxEvents) throws IOException {
        return TaskCompletionEvent.EMPTY_ARRAY;
    }

    @Override
    public JobStatus[] getAllJobs() {
        return null;
    }

    @Override
    public String[] getTaskDiagnostics(TaskAttemptID taskid) throws IOException {
        return new String[0];
    }

    @Override
    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapred.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    @Override
    public AccessControlList getQueueAdmins(String queueName) throws IOException {
        return new AccessControlList(" ");
    }

    @Override
    public String getStagingAreaDir() throws IOException {
        Path stagingRootDir = new Path(this.conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String user = ugi != null ? ugi.getShortUserName() + this.rand.nextInt() : "dummy" + this.rand.nextInt();
        return this.fs.makeQualified(new Path(stagingRootDir, user + "/.staging")).toString();
    }

    @Override
    public JobStatus[] getJobsFromQueue(String queue) throws IOException {
        return null;
    }

    @Override
    public JobQueueInfo[] getQueues() throws IOException {
        return null;
    }

    @Override
    public JobQueueInfo getQueueInfo(String queue) throws IOException {
        return null;
    }

    @Override
    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        return null;
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return null;
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        return 0L;
    }

    private class Job
    extends Thread
    implements TaskUmbilicalProtocol {
        private Path systemJobDir;
        private Path systemJobFile;
        private Path localJobDir;
        private Path localJobFile;
        private JobID id;
        private JobConf job;
        private JobStatus status;
        private ArrayList<TaskAttemptID> mapIds = new ArrayList();
        private JobProfile profile;
        private FileSystem localFs;
        boolean killed = false;
        private TrackerDistributedCacheManager trackerDistributerdCacheManager;
        private TaskDistributedCacheManager taskDistributedCacheManager;
        private Counters completedTaskCounters = new Counters();
        private Counters currentCounters = new Counters();

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) {
            return 17L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Job(JobID jobid, String jobSubmitDir) throws IOException {
            this.systemJobDir = new Path(jobSubmitDir);
            this.systemJobFile = new Path(this.systemJobDir, "job.xml");
            this.id = jobid;
            this.localFs = FileSystem.getLocal(LocalJobRunner.this.conf);
            this.localJobDir = this.localFs.makeQualified(LocalJobRunner.this.conf.getLocalPath(LocalJobRunner.jobDir));
            this.localJobFile = new Path(this.localJobDir, this.id + ".xml");
            this.trackerDistributerdCacheManager = new TrackerDistributedCacheManager(LocalJobRunner.this.conf, new DefaultTaskController());
            this.taskDistributedCacheManager = this.trackerDistributerdCacheManager.newTaskDistributedCacheManager(LocalJobRunner.this.conf);
            this.taskDistributedCacheManager.setup(new LocalDirAllocator("mapred.local.dir"), new File(this.systemJobDir.toString()), "archive", "archive");
            if (DistributedCache.getSymlink(LocalJobRunner.this.conf)) {
                LOG.warn((Object)"LocalJobRunner does not support symlinking into current working dir.");
            }
            TaskRunner.setupWorkDir(LocalJobRunner.this.conf, new File(this.localJobDir.toUri()).getAbsoluteFile());
            FSDataOutputStream out = this.localFs.create(this.localJobFile);
            try {
                LocalJobRunner.this.conf.writeXml(out);
            }
            finally {
                ((OutputStream)out).close();
            }
            this.job = new JobConf(this.localJobFile);
            if (!this.taskDistributedCacheManager.getClassPaths().isEmpty()) {
                this.setContextClassLoader(this.taskDistributedCacheManager.makeClassLoader(this.getContextClassLoader()));
            }
            this.profile = new JobProfile(this.job.getUser(), this.id, this.systemJobFile.toString(), "http://localhost:8080/", this.job.getJobName());
            this.status = new JobStatus(this.id, 0.0f, 0.0f, 1);
            LocalJobRunner.this.jobs.put(this.id, this);
            this.start();
        }

        JobProfile getProfile() {
            return this.profile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JobID jobId = this.profile.getJobID();
            JobContext jContext = new JobContext(LocalJobRunner.this.conf, (org.apache.hadoop.mapreduce.JobID)jobId);
            OutputCommitter outputCommitter = this.job.getOutputCommitter();
            try {
                block28: {
                    JobSplit.TaskSplitMetaInfo[] taskSplitMetaInfos = SplitMetaInfoReader.readSplitMetaInfo(jobId, this.localFs, LocalJobRunner.this.conf, this.systemJobDir);
                    int numReduceTasks = this.job.getNumReduceTasks();
                    if (numReduceTasks > 1 || numReduceTasks < 0) {
                        numReduceTasks = 1;
                        this.job.setNumReduceTasks(1);
                    }
                    outputCommitter.setupJob(jContext);
                    this.status.setSetupProgress(1.0f);
                    HashMap<TaskAttemptID, MapOutputFile> mapOutputFiles = new HashMap<TaskAttemptID, MapOutputFile>();
                    for (int i = 0; i < taskSplitMetaInfos.length; ++i) {
                        if (this.isInterrupted()) {
                            throw new InterruptedException();
                        }
                        TaskAttemptID mapId = new TaskAttemptID(new TaskID(jobId, true, i), 0);
                        this.mapIds.add(mapId);
                        MapTask map = new MapTask(this.systemJobFile.toString(), mapId, i, taskSplitMetaInfos[i].getSplitIndex(), 1);
                        map.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                        JobConf localConf = new JobConf(this.job);
                        TaskRunner.setupChildMapredLocalDirs(map, localConf);
                        MapOutputFile mapOutput = new MapOutputFile();
                        mapOutput.setConf(localConf);
                        mapOutputFiles.put(mapId, mapOutput);
                        map.setJobFile(this.localJobFile.toString());
                        localConf.setUser(map.getUser());
                        map.localizeConfiguration(localConf);
                        map.setConf(localConf);
                        LocalJobRunner.this.map_tasks += 1;
                        LocalJobRunner.this.myMetrics.launchMap(mapId);
                        map.run(localConf, this);
                        LocalJobRunner.this.myMetrics.completeMap(mapId);
                        LocalJobRunner.this.map_tasks -= 1;
                        this.updateCounters(map);
                    }
                    TaskAttemptID reduceId = new TaskAttemptID(new TaskID(jobId, false, 0), 0);
                    try {
                        if (numReduceTasks <= 0) break block28;
                        ReduceTask reduce = new ReduceTask(this.systemJobFile.toString(), reduceId, 0, this.mapIds.size(), 1);
                        reduce.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                        JobConf localConf = new JobConf(this.job);
                        TaskRunner.setupChildMapredLocalDirs(reduce, localConf);
                        for (int i = 0; i < this.mapIds.size(); ++i) {
                            if (!this.isInterrupted()) {
                                TaskAttemptID mapId = this.mapIds.get(i);
                                Path mapOut = ((MapOutputFile)mapOutputFiles.get(mapId)).getOutputFile();
                                MapOutputFile localOutputFile = new MapOutputFile();
                                localOutputFile.setConf(localConf);
                                Path reduceIn = localOutputFile.getInputFileForWrite(mapId.getTaskID(), this.localFs.getFileStatus(mapOut).getLen());
                                if (!this.localFs.mkdirs(reduceIn.getParent())) {
                                    throw new IOException("Mkdirs failed to create " + reduceIn.getParent().toString());
                                }
                                if (this.localFs.rename(mapOut, reduceIn)) continue;
                                throw new IOException("Couldn't rename " + mapOut);
                            }
                            throw new InterruptedException();
                        }
                        if (!this.isInterrupted()) {
                            reduce.setJobFile(this.localJobFile.toString());
                            localConf.setUser(reduce.getUser());
                            reduce.localizeConfiguration(localConf);
                            reduce.setConf(localConf);
                            LocalJobRunner.this.reduce_tasks += 1;
                            LocalJobRunner.this.myMetrics.launchReduce(reduce.getTaskID());
                            reduce.run(localConf, this);
                            LocalJobRunner.this.myMetrics.completeReduce(reduce.getTaskID());
                            LocalJobRunner.this.reduce_tasks -= 1;
                            this.updateCounters(reduce);
                            break block28;
                        }
                        throw new InterruptedException();
                    }
                    finally {
                        for (MapOutputFile output : mapOutputFiles.values()) {
                            output.removeAll();
                        }
                    }
                }
                outputCommitter.commitJob(jContext);
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(5);
                } else {
                    this.status.setRunState(2);
                }
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            catch (Throwable t) {
                try {
                    outputCommitter.abortJob(jContext, 3);
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Error cleaning up job:" + this.id));
                }
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(5);
                } else {
                    this.status.setRunState(3);
                }
                LOG.warn((Object)this.id, t);
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            finally {
                try {
                    LocalJobRunner.this.fs.delete(this.systemJobFile.getParent(), true);
                    this.localFs.delete(this.localJobFile, true);
                    this.taskDistributedCacheManager.release();
                    this.trackerDistributerdCacheManager.purgeCache();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error cleaning up " + this.id + ": " + e));
                }
            }
        }

        @Override
        public JvmTask getTask(JvmContext context) {
            return null;
        }

        @Override
        public boolean statusUpdate(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            LOG.info((Object)taskStatus.getStateString());
            float taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0.0f) {
                float numTasks = this.mapIds.size();
                this.status.setMapProgress(taskIndex / numTasks + taskStatus.getProgress() / numTasks);
            } else {
                this.status.setReduceProgress(taskStatus.getProgress());
            }
            this.currentCounters = Counters.sum(this.completedTaskCounters, taskStatus.getCounters());
            return true;
        }

        @Override
        public void commitPending(TaskAttemptID taskid, TaskStatus taskStatus) throws IOException, InterruptedException {
            this.statusUpdate(taskid, taskStatus);
        }

        private void updateCounters(Task task) {
            this.completedTaskCounters.incrAllCounters(task.getCounters());
        }

        @Override
        public void reportDiagnosticInfo(TaskAttemptID taskid, String trace) {
        }

        @Override
        public void reportNextRecordRange(TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
            LOG.info((Object)("Task " + taskid + " reportedNextRecordRange " + range));
        }

        @Override
        public boolean ping(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public boolean canCommit(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public void done(TaskAttemptID taskId) throws IOException {
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                this.status.setMapProgress(1.0f);
            } else {
                this.status.setReduceProgress(1.0f);
            }
        }

        @Override
        public synchronized void fsError(TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("FSError: " + message + "from task: " + taskId));
        }

        @Override
        public void shuffleError(TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("shuffleError: " + message + "from task: " + taskId));
        }

        @Override
        public synchronized void fatalError(TaskAttemptID taskId, String msg) throws IOException {
            LOG.fatal((Object)("Fatal: " + msg + "from task: " + taskId));
        }

        @Override
        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, TaskAttemptID id) throws IOException {
            return new MapTaskCompletionEventsUpdate(TaskCompletionEvent.EMPTY_ARRAY, false);
        }
    }
}

