% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/senDownload.R
\name{senDownload}
\alias{senDownload}
\title{Download Sentinel images from a search list}
\usage{
senDownload(
  searchres,
  AppRoot,
  username = NULL,
  password = NULL,
  nattempts = 5,
  unzip = FALSE,
  overwrite = FALSE,
  omit.md5.error = FALSE,
  ...
)
}
\arguments{
\item{searchres}{the output from the \code{\link{senSearch}} function.}

\item{AppRoot}{the directory where the outcoming time series are saved.}

\item{username}{ESA’s `SciHub' username.}

\item{password}{ESA’s `SciHub' password.}

\item{nattempts}{the number of attempts to download an image in case it
becomes corrupted.}

\item{unzip}{logical argument. If \code{TRUE}, unzips the images.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{omit.md5.error}{logical argument. If \code{TRUE}, omits md5 errors and 
do not removes the downloaded image.}

\item{...}{arguments for nested functions.
 \itemize{
       \item \code{dates} a vector with the capturing dates being considered
  for downloading. 
       \item \code{bFilter} a vector with the bands to be extracted when \code{unzip=TRUE}. If not
  supplied, all bands are extracted.
}}
}
\value{
this function does not return anything. It saves the imagery as
`zip’ (and JP2 files) in a folder called `raw’ (`unzip’) in the
 \code{AppRoot} directory.
}
\description{
\code{senDownload} downloads the images from a list of uniform resource
locators (URLs) generated by the \code{\link{senSearch}} function from ESA’s
`SciHub' web service. The images are saved as GTiff files in the \code{AppRoot}
directory.
}
\details{
\code{senDownload} downloads the list of URLs provided by 
\code{\link{senSearch}}. In case the process is interrupted, the image file
could be corrupted. The function detects the corrupted files and restarts the
process. To prevent the computer from crashing, there is a maximum number of
attempts to try to donwnload the image (\code{nattempts}). The default number
of attempts is set to 3. The function requires an ESA’s `SciHub' account, which
can be obtained 
\href{https://scihub.copernicus.eu/dhus/#/self-registration}{here}.

When \code{unzip = TRUE}, the function decompresses the imagery. If
only a subset of bands is required, band names can be provided through the
\code{bFilter} argument. The band names are specified by “B”, followed by 
the two-digit band number, and the resolution of the band (either 10m, 20m,
or 60m) (e.g, "B01_10m"). Image decompression duplicates the information due
to the presence of both, compressed and decompressed images. Set 
\code{raw.rm = TRUE} to remove former ones.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# download S2MSI1C products sensed by Sentinel-2
# in July-August 2018
sres <- senSearch(startDate = as.Date("2018-07-29","\%Y-\%m-\%d"),
                       endDate = as.Date("2018-08-06","\%Y-\%m-\%d"),
                       platform = "Sentinel-2",
                       extent = ex.navarre,
                       product = "S2MSI1C",
                       username = "username",
                       password = "password")

# filtering the path R094 where Navarre is located
names(sres)
sres.sen.R094 <- sres[grepl("R094", names(sres))]
names(sres.sen.R094)
# list the dates in sres
senGetDates(names(sres.sen.R094),format="\%Y\%j")
wdir <- file.path(tempdir(),"Path_for_downloading_folder")
# donwload the imagery
senDownload(searchres = sres.sen.R094,
            username = "username",
            password = "password",
            AppRoot = wdir,
            unzip = TRUE)
wdir.sen.unzip <- file.path(wdir,"Sentinel","unzip")
files.sen.unzip<-list.files(wdir.sen.unzip,
                            pattern = "\\\\TCI.jp2$",
                            full.names = TRUE,
                            recursive = TRUE)
img.sen.rgb<-stack(files.sen.unzip[1])
plotRGB(img.sen.rgb)
}
}
