% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varNBR.R
\name{varNBR}
\alias{varNBR}
\title{Calculate the normalized burn ratio (NBR)}
\usage{
varNBR(nir, swir2)
}
\arguments{
\item{nir}{a \code{raster} with the NIR band of the capture.}

\item{swir2}{a \code{raster} with the SWIR2 band of the capture.}
}
\value{
A NBR image in \code{raster} format.
}
\description{
\code{varNBR} computes the normalized burn ratio (NBR) from the
near-infrared (NIR) and shortwave-infrared 2 (SWIR2) bands.
}
\details{
The normalized burn ratio (NBR) is an index that identifies burned areas by 
comparing its value before and after the fire event. It is calculated using the
NIR and SWIR2 bands \insertCite{garcia1991mapping}{RGISTools}.This function
is used within \code{\link{ls7FolderToVar}}, \code{\link{ls8FolderToVar}}, 
\code{\link{modFolderToVar}} and \code{\link{senFolderToVar}}.
}
\examples{
# path to the cropped and cutted MODIS images for the region of Navarre
wdir <- system.file("ExNavarreVar", package = "RGISTools")
# list all the tif files
files.mod <- list.files(wdir, pattern="\\\\.tif$", recursive = TRUE, full.names = TRUE)
# print the MOD09 bands
getRGISToolsOpt("MOD09BANDS")

# select the NIR and SWIR2 bands
files.mod.nir <- raster(files.mod[2])
files.mod.swir2 <- raster(files.mod[7])
# calculate the NBR image
files.mod.nbr <- varNBR(files.mod.nir, files.mod.swir2)
# plot the image
spplot(files.mod.nbr,col.regions=rev(heat.colors(20)))
}
\references{
\insertRef{garcia1991mapping}{RGISTools}
}
