% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genGetDates.R
\name{genGetDates}
\alias{genGetDates}
\title{Return the capturing date from the name of a raster layer}
\usage{
genGetDates(str, ...)
}
\arguments{
\item{str}{\code{character} argument containing the date in julian format "\code{YYYYJJJ}".}

\item{...}{arguments for nested functions:
\itemize{
  \item \code{format} the format of the date being returned.
}}
}
\value{
a \code{Date} class object with the date of the image.
}
\description{
\code{genGetDates} extracts the date of one or several images when the name
of the layer includes the date in the "\code{YYYYJJJ}" format.
}
\details{
The function reads a date from a \code{character} class object in year-julian
("\code{YYYYJJJ}") format and returns a \code{Date} class object.
}
\examples{
img <- matrix(1:16, ncol = 4, byrow = TRUE)
r <- raster(img)
names(r) <- c("RandomImage_2018034")

spplot(r)
genGetDates(names(r), format = "\%Y\%j")

}
