% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_loading.R
\docType{methods}
\name{plot_loading}
\alias{plot_loading}
\alias{plot_loading,MPCA-method}
\title{Plot two dimensional loadings from MPCA}
\usage{
plot_loading(Object, type = "n", pc = 1, ...)

\S4method{plot_loading}{MPCA}(Object, type = "b", pc = 1, ...)
}
\arguments{
\item{Object}{a MPCA object}

\item{type}{the value type of loadings, \emph{p} for positive, 
\emph{n} for negative, and \emph{b} for negative and positive 
loading values.}

\item{pc}{the number of the principal component to plot}

\item{...}{Other parameters passes to \code{\link[graphics]{filled.contour}}
function.}
}
\description{
`plot_loading` plot the loadings of the previously MPCA performed.
}
\details{
This function takes the loadings of MPCA and eval if a certain
  variable was removed previous compute de MPCA and fill the removed
  variables with cero. Then, it plots the loadings of a single
  principal component in two dimensions.
}
\examples{

library(colorRamps)
data(MTBLS579)
# MPCA with mean-centered and scaled data
MTBLS579_mpca <- m_prcomp(MTBLS579)
# Negative loadings of the first principal component
\donttest{
plot_loading(MTBLS579_mpca, type = "n", pc = 1,
             color.palette = matlab.like)
# Positive loadings of the first principal component
plot_loading(MTBLS579_mpca, type = "p", pc = 1,
             color.palette = matlab.like)
}
}
