% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{autoGapProd}
\alias{autoGapProd}
\title{Fit best production function model}
\usage{
autoGapProd(
  tsl,
  type = "hp",
  q = 0.01,
  method = "MLE",
  criterion = "BIC",
  fast = TRUE,
  nModels = 5,
  nawruPoss = list(maxCycleLag = 2, trend = c("RW2", "DT"), cycle = c("AR1", "AR2"),
    errorARmax = 1, errorMAmax = 0, type = c("TKP", "NKP"), exoNames = c("ws", "prod",
    "tot"), signalToNoise = NULL),
  tfpPoss = list(maxCycleLag = 2, trend = c("RW2", "DT"), cycle = c("AR1", "AR2",
    "RAR2"), cubsARmax = 0, errorARmax = 1, errorMAmax = 0, signalToNoise = NULL),
  auto = "gap"
)
}
\arguments{
\item{tsl}{A list of time series objects, see details.}

\item{type}{The variance restriction type. Possible options are \code{"basic"},
\code{"hp"}, see \code{initializeRestr}. The default is \code{type = "hp"}.}

\item{q}{Quantile for the Inverse Gamma distribution (only used if \code{type = "hp"}), 
see \code{initializeRestr}. The default is \code{q = 0.01}.}

\item{method}{The estimation method. Options are maximum likelihood estimation \code{"MLE"}
and bayesian estimation \code{"bayesian"}. If \code{method = c("MLE", "bayesian")} the 
NAWRU is fitted by MLE and the TFP trend by Bayesian methods. The default is 
\code{method = "MLE"}.}

\item{criterion}{Model selection criterion. Options are the Bayesian information criterion 
\code{"BIC"} and the root mean squared error \code{"RMSE"}, both computed for the second 
observation equation. The default is \code{criterion = "BIC"}. For Bayesian estimation 
and  \code{criterion = "RMSE"}, the mean RMSE is used.}

\item{fast}{Boolean, indicating whether a "fast" procedure should be used, see details.}

\item{nModels}{Integer, the maximum number of models for each unobserved component model.}

\item{nawruPoss}{List with possible model specifications for the NAWRU, see details.}

\item{tfpPoss}{List with possible model specifications for the NAWRU, see details.}

\item{auto}{If \code{auto = "NAWRU"} or \code{auto = "TFP"}, the function only 
finds the most suitable NAWRU or TFP model, respectively. The default is 
\code{auto = "gap"}.}

\item{BIC}{Bayesian information criterion of chosen model.}
}
\value{
A list containing three components: \code{gap} (the best model of class \code{"gap"}), 
\code{tfp} (a nested list of TFP models, fitted objects and model fit criteria), \code{nawru} 
(a nested list of NAWRU models, fitted objects and model fit criteria). The lists \code{nawru}
and \code{tfp} contain a list of models, a list of fitted objects and a dataframe \code{info},
which contains
  \item{loglik}{log-likelihood function at optimum}
  \item{AIC}{Akaike information criterion}
  \item{BIC}{Bayesian information criterion}
  \item{HQC}{Hannan-Quinn information criterion}
  \item{RMSE}{Root mean squared error}
  \item{R2}{Coefficient of determination (R squared)}
  \item{signal-to-noise}{Signal-to-noise ratio}
  \item{LjungBox}{p-value of Ljung-Box test for autocorrelation (H0 = no autocorrelation)}
  \item{convergence}{0 indicates convergence of the optimization}
  \item{rrange}{relative range of trend series w.r.t original series}
  \item{neg}{1 indicates that negative values are present in the trend series}
  \item{rev}{relative excess volatility w.r.t. original series (stationary series)}
  \item{rsd}{relative standard deviation w.r.t. original series (stationary series)}
  \item{cor}{correlation between trend and original series (stationary series)}
  \item{msdtg}{mean standardized deviation (stationary trend)}
  \item{magtg}{mean absolute growth of trend (stationaty trend)}
  \item{drop}{1 indicates the model should be dropped}
}
\description{
Finds the most suitable model for the NAWRU and the TFP trend according to 
  the BIC or the RMSE. The function computes the output gap based on the chosen models.
}
\details{
For \code{fast = TRUE}, the function pre-selects suitable models by applying the 
  following procedure: A HP-filtered trend is computed based on which the best trend and 
  cycle models are chosen according to the BIC. Also based on the HP trend, a variety of 
  different specifications for the second observation equation are estimated in a 
  univariate regression and the best models are selected via the BIC. The \code{nModels} 
  best models are subsequently estimated in the usual bivariate unobserved component 
  model. For \code{fast = FALSE}, a variety of models is estimated in the usual bivariate 
  unobserved component framework.

The input component \code{nawruPoss} is a list containing a (sub-) set of the 
  following components: 
  \describe{
  \item{maxCycleLag}{Maximum cycle lag included in the second observation equation.}
  \item{trend}{Trend model specification.}
  \item{cycle}{Cycle model specification.}
  \item{errorARmax}{Maximum autoregressive order of the error term in the second 
  observation equation.}
  \item{errorMAmax}{Maximum moving average order of the error term in the second 
  observation equation.}
  \item{type}{Type of Phillip's curve.}
  \item{exoNames}{Names of the exogenous variables potentially included in the Phillip's 
  curve (need to be included in the list of time series \code{tsl}).}
  \item{signal-to-noise}{Signal-to-noise ratio.}
  }

The input component \code{tfpPoss} is a list containing a (sub-) set of the 
  following components: 
  \describe{
  \item{maxCycleLag}{Maximum cycle lag included in the second observation equation.}
  \item{trend}{Trend model specification.}
  \item{cycle}{Cycle model specification.}
  \item{cubsARmax}{Maximum CUBS autoregressive order.}
  \item{errorARmax}{Maximum autoregressive order of the error term in the second 
  observation equation.}
  \item{errorMAmax}{Maximum moving average order of the error term in the second 
  observation equation.}
  \item{signal-to-noise}{Signal-to-noise ratio.}
  }

The list of time series \code{tsl} needs to have the following components 
 (plus those series included in the list component \code{exoNames} in \code{nawruPoss}):
\describe{
  \item{ur}{Unemployment rate.}
  \item{nulc}{Nominal Unit labor costs, if \code{type = "TKP"}.}
  \item{rulc}{Real unit labor costs, if \code{type = "NKP"}.}
  \item{tfp}{Total factor productivity.}
  \item{cubs}{Capacity utilization economic sentiment indicator.}
  \item{lfnd}{Labor force non-domestic (unit: 1000 persons).}
  \item{parts}{Participation rate.}
  \item{ahours}{Average hours worked (unit: hours).}
  \item{gdp}{Gross domestic product at constant prices (unit: bn National currency, code: OVGD).}
  \item{k}{Net capital stock at constant prices: total economy (unit: bn National currency, code: OKND).}
  \item{popw}{Population: 15 to 64 years (unit: 1000 persons, code: NPAN).}
  }

The set of tested models is extensive but not exhaustive. The best model is 
  solely based on convergence and the chosen criterion (RMSE or BIC). A manual check 
  of the results is highly recommended.

In some cases, more than \code{nModels} are checked. For instance, if a 
  re-parametrized and regular AR(2) process are options for the cycle.
}
