% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/custom-mets.R
\name{get_custom_metric}
\alias{get_custom_metric}
\title{Gets a custom metric to which the user has access to}
\usage{
get_custom_metric(account.id, webproperty.id, metric.id, token)
}
\arguments{
\item{account.id}{Account ID for the custom metric to retrieve.}

\item{webproperty.id}{Web property ID for the custom metric to retrieve.}

\item{metric.id}{The ID of the custom metric to retrieve.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
An Analytics custom metric.
\item{kind}{Kind value for a custom metric. Set to "analytics#customMetric". It is a read-only field.}
\item{id}{Custom metric ID.}
\item{account.id}{Account ID.}
\item{webproperty.id}{Property ID.}
\item{name}{Name of the custom metric.}
\item{index}{Index of the custom metric.}
\item{scope}{Scope of the custom metric: HIT or PRODUCT.}
\item{active}{Boolean indicating whether the custom metric is active.}
\item{type}{Data type of custom metric.}
\item{min_value}{Min value of custom metric.}
\item{max_value}{Max value of custom metric.}
\item{created}{Time the custom metric was created.}
\item{updated}{Time the custom metric was last modified.}
\item{self.link}{Link for the custom metric}
\item{parent.link}{Parent link for the custom metric. Points to the property to which the custom metric belongs.}
\item{parent.link.type}{Type of the parent link. Set to "analytics#webproperty".}
\item{parent.link.href}{Link to the property to which the custom metric belongs.}
}
\description{
Gets a custom metric to which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/customMetrics}{Management API - Custom metrics}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_custom_dimension}};
  \code{\link{get_experiment}}; \code{\link{get_filter}};
  \code{\link{get_goal}}; \code{\link{get_profile}};
  \code{\link{get_unsampled_report}};
  \code{\link{get_upload}}; \code{\link{get_webproperty}};
  \code{\link{list_accounts}};
  \code{\link{list_custom_dimensions}};
  \code{\link{list_custom_metrics}};
  \code{\link{list_custom_sources}};
  \code{\link{list_experiments}};
  \code{\link{list_filters}}; \code{\link{list_goals}};
  \code{\link{list_profiles}}; \code{\link{list_segments}};
  \code{\link{list_unsampled_reports}};
  \code{\link{list_uploads}};
  \code{\link{list_webproperties}}
}

