% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/accounts.R
\name{list_accounts}
\alias{list_accounts}
\title{Lists all accounts which the user has access to}
\usage{
list_accounts(start.index = NULL, max.results = NULL, token)
}
\arguments{
\item{start.index}{integer. An index of the first account to retrieve. Use this parameter as a pagi- nation mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of accounts to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
An account collection provides a list of Analytics accounts to which a user has access. The account collection is the entry point to all management information. Each resource in the collection corresponds to a single Analytics account.
\item{id}{Account ID.}
\item{name}{Account name.}
\item{permissions}{Permissions the user has for this account.}
\item{created}{Time the account was created.}
\item{updated}{Time the account was last modified.}
}
\description{
Lists all accounts which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/accounts}{Google Management API - Accounts}

\href{https://ga-dev-tools.appspot.com/account-explorer/}{Google Analytics Demos & Tools - Account Explorer}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_experiment}};
  \code{\link{get_filter}}; \code{\link{get_goal}};
  \code{\link{get_profile}};
  \code{\link{get_unsampled_report}};
  \code{\link{get_webproperty}};
  \code{\link{list_custom_sources}};
  \code{\link{list_experiments}};
  \code{\link{list_filters}}; \code{\link{list_goals}};
  \code{\link{list_profiles}}; \code{\link{list_segments}};
  \code{\link{list_unsampled_reports}};
  \code{\link{list_webproperties}}
}

