/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset;

import freak.core.control.Schedule;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.module.fitness.pointset.AbstractMultiObjectiveRobustRegressionFitness;
import freak.module.fitness.pointset.util.ResidualContainer;
import freak.module.fitness.pointset.util.ResidualHyperPlane;
import freak.module.searchspace.PointSet;
import freak.module.searchspace.PointSetGenotype;
import java.util.Arrays;

public abstract class AbstractStaticMultiObjectiveRobustRegressionFitness
extends AbstractMultiObjectiveRobustRegressionFitness {
    public AbstractStaticMultiObjectiveRobustRegressionFitness(Schedule schedule) {
        super(schedule);
    }

    public final double[] evaluate(Individual individual, IndividualList list) {
        Double[] d = individual.getLatestKnownFitnessValue();
        if (d != null) {
            int bound = d.length;
            double[] result = new double[bound];
            int i = 0;
            while (i < bound) {
                result[i] = d[i];
                ++i;
            }
            return result;
        }
        double[] fitness = this.evaluate(individual.getPhenotype());
        int bound = fitness.length;
        Double[] cache = new Double[bound];
        int i = 0;
        while (i < bound) {
            cache[i] = new Double(fitness[i]);
            ++i;
        }
        individual.setLatestKnownFitnessValue(cache);
        return fitness;
    }

    protected double evaluateOLSFitOnH(Genotype genotype) {
        double value = 0.0;
        PointSet.Point[] allPoints = ((PointSetGenotype)genotype).getPoints();
        PointSet.Point[] supportPoints = ((PointSetGenotype)genotype).getChoosenSubSet();
        int pointDim = ((PointSetGenotype)genotype).getPointDimension();
        if (supportPoints.length == 0) {
            value = Double.NEGATIVE_INFINITY;
            return value;
        }
        if (supportPoints.length != supportPoints[0].getDimension()) {
            value = Double.NEGATIVE_INFINITY;
            return value;
        }
        ResidualHyperPlane hyperPlane = new ResidualHyperPlane(supportPoints);
        Object[] residuals = new ResidualContainer[allPoints.length];
        hyperPlane.updateResiduals((ResidualContainer[])residuals, allPoints);
        Arrays.sort(residuals);
        hyperPlane.computeParamLS(allPoints, (ResidualContainer[])residuals, this.h);
        int i = 0;
        while (i < allPoints.length) {
            value += -((ResidualContainer)residuals[i]).squaredResidual;
            ++i;
        }
        return value;
    }

    protected abstract double[] evaluate(Genotype var1);

    protected double evaluateResiduals(int quantile) {
        Arrays.sort(this.m_hResiduals);
        double valueOfSolution = 0.0;
        int i = 0;
        while (i < quantile) {
            valueOfSolution += this.m_hResiduals[i].squaredResidual;
            ++i;
        }
        return -valueOfSolution;
    }
}

