/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.generalstring;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.inspector.StringArrayWrapper;
import freak.core.population.Genotype;
import freak.core.util.FreakMath;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;
import java.io.Serializable;

public class IsingModelCliques
extends AbstractStaticSingleObjectiveFitnessFunction
implements Configurable,
BatchEventListener {
    public static final int RANDOM = 0;
    public static final int EVENLY = 1;
    public static final int STAIRS = 2;
    private int bridgeSelectionStrategy = 0;
    private int numberOfBridges;
    private int numberOfCliques;
    private int corridorSize1 = 0;
    private int corridorSize2 = 0;
    private Clique[] cliques;
    private int[][] bridges;
    private int[][] adjacencyLists;

    public IsingModelCliques(Schedule schedule) {
        super(schedule);
        int dim = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        if (((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension() % 2 == 0) {
            this.setPropertyNumberOfCliques(new Integer(2));
        } else {
            this.setPropertyNumberOfCliques(new Integer(dim));
        }
        this.setPropertyNumberOfBridges(new Integer(1));
    }

    public void initialize() {
        super.initialize();
        int dim = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        if (this.cliques != null && dim != this.cliques.length * this.cliques[0].getSize()) {
            if (((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension() % 2 == 0) {
                this.setPropertyNumberOfCliques(new Integer(2));
            } else {
                this.setPropertyNumberOfCliques(new Integer(dim));
            }
            this.initCliques();
            this.chooseEdges();
        }
    }

    protected double evaluate(Genotype genotype) {
        double fitness = 0.0;
        int[] gen = ((GeneralStringGenotype)genotype).getIntArray();
        if (this.bridges.length != this.getMaximalNumberOfBridges() || this.corridorSize1 < this.cliques[0].getSize() && this.corridorSize1 != 0 || this.corridorSize2 < this.cliques[0].getSize() && this.corridorSize2 != 0) {
            int i = 0;
            while (i < this.cliques.length) {
                fitness += this.getFitnessInsideClique(this.cliques[i], gen);
                ++i;
            }
            i = 0;
            while (i < this.bridges.length) {
                if (gen[this.bridges[i][0]] == gen[this.bridges[i][1]]) {
                    fitness += 1.0;
                }
                ++i;
            }
        } else {
            Clique clique = new Clique(0, gen.length);
            fitness += this.getFitnessInsideClique(clique, gen);
        }
        return fitness;
    }

    private double getFitnessInsideClique(Clique clique, int[] gen) {
        double result = 0.0;
        int k = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getNumChars();
        int[] colors = new int[k];
        int j = 0;
        while (j < clique.size) {
            int index = clique.start + j;
            int n = gen[index];
            colors[n] = colors[n] + 1;
            ++j;
        }
        j = 0;
        while (j < k) {
            result += (double)(colors[j] * (colors[j] - 1) / 2);
            ++j;
        }
        return result;
    }

    public String getName() {
        return "Ising Model (Cliques)";
    }

    public String getDescription() {
        return "The Ising Model is a model derived from statistical mechanics describing the behavior of atoms with two spins where neighbored atoms tend to orient in the same direction as their neighbors.\nAnother view is an inversion of the colorability problem: an edge contributes a value of 1 to the fitness if and only if its nodes have got the same color. So, all colorings with only one color are optimal.\nHere, the graph is described by a specified number of cliques of equal size connected via a specified amount of bridges. Bridges are randomly chosen edges between two different cliques.";
    }

    public double getLowerBound() throws UnsupportedOperationException {
        int fitness = 0;
        int k = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getNumChars();
        if (this.cliques != null) {
            int i = 0;
            while (i < this.cliques.length) {
                int averageSize = this.cliques[i].size / k;
                int fitnessOfAverageSubClique = averageSize * (averageSize - 1) / 2;
                fitness += k * fitnessOfAverageSubClique;
                ++i;
            }
        }
        return fitness;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        int fitness = 0;
        if (this.cliques != null) {
            int i = 0;
            while (i < this.cliques.length) {
                fitness += this.cliques[i].size * (this.cliques[i].size - 1) / 2;
                ++i;
            }
        }
        return fitness + this.numberOfBridges;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    private void initCliques() {
        if (((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension() % this.numberOfCliques != 0) {
            throw new IllegalArgumentException("The number of cliques is not a factor of the search space dimension.");
        }
        this.cliques = new Clique[this.numberOfCliques];
        int cliqueSize = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension() / this.numberOfCliques;
        int i = 0;
        while (i < this.numberOfCliques) {
            this.cliques[i] = new Clique(i * cliqueSize, cliqueSize);
            ++i;
        }
    }

    private void chooseEdges() {
        this.bridges = new int[this.numberOfBridges][2];
        switch (this.bridgeSelectionStrategy) {
            case 0: {
                this.chooseEdgesRandomly();
                break;
            }
            case 1: {
                this.chooseEdgesEvenly();
                break;
            }
            case 2: {
                this.chooseEdgesAsStairs();
            }
        }
        this.createAdjacencyLists();
    }

    public void chooseEdgesAsStairs() {
        if (this.cliques.length == 2) {
            int n = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
            this.numberOfBridges = n * n / 16 + n / 4;
            this.bridges = new int[this.numberOfBridges][2];
            int index = 0;
            int i = 0;
            while (i < n / 4) {
                int numberOfEdges = n / 2 - 2 * i;
                int[] endNodes = FreakMath.getKofN(this.schedule, numberOfEdges, n / 2);
                int j = 0;
                while (j < endNodes.length) {
                    this.bridges[index][0] = i;
                    this.bridges[index][1] = endNodes[j] + n / 2;
                    ++index;
                    ++j;
                }
                ++i;
            }
        }
    }

    private void createAdjacencyLists() {
        int dim = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        this.adjacencyLists = new int[dim][dim - 1];
        int[] sizes = new int[dim];
        int i = 0;
        while (i < this.bridges.length) {
            int n = this.bridges[i][0];
            int n2 = sizes[n];
            sizes[n] = n2 + 1;
            this.adjacencyLists[this.bridges[i][0]][n2] = this.bridges[i][1];
            int n3 = this.bridges[i][1];
            int n4 = sizes[n3];
            sizes[n3] = n4 + 1;
            this.adjacencyLists[this.bridges[i][1]][n4] = this.bridges[i][0];
            ++i;
        }
        i = 0;
        while (i < this.cliques.length) {
            int j = this.cliques[i].getStart();
            while (j < this.cliques[i].getStart() + this.cliques[i].getSize()) {
                int k = j + 1;
                while (k < this.cliques[i].getStart() + this.cliques[i].getSize()) {
                    int n = j;
                    int n5 = sizes[n];
                    sizes[n] = n5 + 1;
                    this.adjacencyLists[j][n5] = k;
                    int n6 = k;
                    int n7 = sizes[n6];
                    sizes[n6] = n7 + 1;
                    this.adjacencyLists[k][n7] = j;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.adjacencyLists.length) {
            int[] compressed = new int[sizes[i]];
            System.arraycopy(this.adjacencyLists[i], 0, compressed, 0, sizes[i]);
            this.adjacencyLists[i] = compressed;
            ++i;
        }
    }

    public int[] getAdjacencyList(int node) {
        return this.adjacencyLists[node];
    }

    private void chooseEdgesRandomly() {
        int i;
        int cliqueSize = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension() / this.numberOfCliques;
        int range = this.numberOfCliques * (this.numberOfCliques - 1) / 2 * (this.corridorSize1 == 0 ? cliqueSize : this.corridorSize1) * (this.corridorSize2 == 0 ? cliqueSize : this.corridorSize2);
        int[][] decodingTable = new int[range][2];
        int counter = 0;
        int firstClique = 0;
        while (firstClique < this.cliques.length - 1) {
            i = 0;
            while (i < (this.corridorSize1 == 0 ? this.cliques[firstClique].getSize() : this.corridorSize1)) {
                int secondClique = firstClique + 1;
                while (secondClique < this.cliques.length) {
                    int j = 0;
                    while (j < (this.corridorSize2 == 0 ? this.cliques[secondClique].getSize() : this.corridorSize2)) {
                        decodingTable[counter][0] = firstClique * cliqueSize + i;
                        decodingTable[counter][1] = secondClique * cliqueSize + j;
                        ++counter;
                        ++j;
                    }
                    ++secondClique;
                }
                ++i;
            }
            ++firstClique;
        }
        int[] encodedEdges = FreakMath.getKofN(this.schedule, this.numberOfBridges, range);
        i = 0;
        while (i < encodedEdges.length) {
            this.bridges[i][0] = decodingTable[encodedEdges[i]][0];
            this.bridges[i][1] = decodingTable[encodedEdges[i]][1];
            ++i;
        }
    }

    private void chooseEdgesEvenly() {
        int cliqueSize = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension() / this.numberOfCliques;
        int numberOfCorridors = this.cliques.length * (this.cliques.length - 1) / 2;
        int counter = 0;
        int corridorCounter = 0;
        int firstClique = 0;
        while (firstClique < this.cliques.length - 1) {
            int secondClique = firstClique + 1;
            while (secondClique < this.cliques.length) {
                int numberOfEdgesInCurrentCorridor = (int)Math.round((double)(this.numberOfBridges * (corridorCounter + 1)) / (double)numberOfCorridors) - counter;
                boolean[] isChosen = new boolean[(this.corridorSize1 == 0 ? this.cliques[firstClique].getSize() : this.corridorSize1) * (this.corridorSize2 == 0 ? this.cliques[secondClique].getSize() : this.corridorSize2)];
                int offsetInSecondClique = 0;
                int indexOfCurrentBridge = 0;
                int i = 0;
                while (i < numberOfEdgesInCurrentCorridor) {
                    this.bridges[counter][0] = firstClique * cliqueSize + i % (this.corridorSize1 == 0 ? this.cliques[firstClique].getSize() : this.corridorSize1);
                    do {
                        this.bridges[counter][1] = secondClique * cliqueSize + (offsetInSecondClique + i) % (this.corridorSize2 == 0 ? this.cliques[secondClique].getSize() : this.corridorSize2);
                        indexOfCurrentBridge = this.bridges[counter][0] % cliqueSize * (this.corridorSize2 == 0 ? this.cliques[secondClique].getSize() : this.corridorSize2) + this.bridges[counter][1] % cliqueSize;
                        if (!isChosen[indexOfCurrentBridge]) continue;
                        ++offsetInSecondClique;
                    } while (isChosen[indexOfCurrentBridge]);
                    isChosen[indexOfCurrentBridge] = true;
                    ++counter;
                    ++i;
                }
                ++corridorCounter;
                ++secondClique;
            }
            ++firstClique;
        }
    }

    private int getMaximalNumberOfBridges() {
        int dim = ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int maxNumberOfBridgesInCorridors = (this.corridorSize1 == 0 ? dim / this.numberOfCliques : this.corridorSize1) * (this.corridorSize2 == 0 ? dim / this.numberOfCliques : this.corridorSize2);
        return this.numberOfCliques * (this.numberOfCliques - 1) / 2 * maxNumberOfBridgesInCorridors;
    }

    public void batchStarted(BatchEvent evt) {
        this.initCliques();
        this.chooseEdges();
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
    }

    public Integer getPropertyNumberOfBridges() {
        return new Integer(this.numberOfBridges);
    }

    public void setPropertyNumberOfBridges(Integer i) {
        this.numberOfBridges = i;
        if (this.numberOfBridges < 0) {
            this.numberOfBridges = 0;
        }
        if (this.numberOfBridges > this.getMaximalNumberOfBridges()) {
            this.numberOfBridges = this.getMaximalNumberOfBridges();
        }
    }

    public String getShortDescriptionForNumberOfBridges() {
        return "Number of bridges";
    }

    public String getLongDescriptionForNumberOfBridges() {
        return "The number of bridges, i.e., the number of edges connecting the two cliques. The bridges are chosen randomly at the start of a new batch and every time the number of bridges is altered.";
    }

    public Integer getPropertyNumberOfCliques() {
        return new Integer(this.numberOfCliques);
    }

    public void setPropertyNumberOfCliques(Integer i) {
        if (i >= 2) {
            if (((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension() % i == 0) {
                this.numberOfCliques = i;
            }
            this.setPropertyNumberOfBridges(new Integer(this.numberOfBridges));
            this.setPropertyCorridorSize1(new Integer(this.corridorSize1));
            this.setPropertyCorridorSize2(new Integer(this.corridorSize2));
        }
    }

    public String getShortDescriptionForNumberOfCliques() {
        return "Number of cliques";
    }

    public String getLongDescriptionForNumberOfCliques() {
        return "The number of cliques. To ensure that all cliques are of equal size, the number of cliques must be a factor of the search space's dimension.";
    }

    public Integer getPropertyCorridorSize1() {
        return new Integer(this.corridorSize1);
    }

    public void setPropertyCorridorSize1(Integer i) {
        this.corridorSize1 = i;
        if (this.corridorSize1 != 0) {
            int cliqueSize = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension() / this.numberOfCliques;
            if (this.corridorSize1 < 1) {
                this.corridorSize1 = 1;
            }
            if (this.corridorSize1 > cliqueSize) {
                this.corridorSize1 = cliqueSize;
            }
        }
        this.setPropertyNumberOfBridges(new Integer(this.numberOfBridges));
    }

    public String getShortDescriptionForCorridorSize1() {
        return "Corridor size (first nodes)";
    }

    public String getLongDescriptionForCorridorSize1() {
        return "If the corridor size is greater than the 0, only the first nodes within the clique can have bridges to nodes in other cliques. The corridor size for first nodes only holds for first nodes of undirected edges. By convention, these are the nodes with smaller indices in the genotype. Using different values for the first and the second node leads to asymmetric distributions.";
    }

    public Integer getPropertyCorridorSize2() {
        return new Integer(this.corridorSize2);
    }

    public void setPropertyCorridorSize2(Integer i) {
        this.corridorSize2 = i;
        if (this.corridorSize2 != 0) {
            int cliqueSize = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension() / this.numberOfCliques;
            if (this.corridorSize2 < 1) {
                this.corridorSize2 = 1;
            }
            if (this.corridorSize2 > cliqueSize) {
                this.corridorSize2 = cliqueSize;
            }
        }
        this.setPropertyNumberOfBridges(new Integer(this.numberOfBridges));
    }

    public String getShortDescriptionForCorridorSize2() {
        return "Corridor size (second nodes)";
    }

    public String getLongDescriptionForCorridorSize2() {
        return "If the corridor size is greater than 0, only the first nodes within the clique can have bridges to nodes in other cliques. The corridor size for second nodes only holds for second nodes of undirected edges. By convention, these are the nodes with larger indices in the genotype. Using different values for the first and the second node leads to asymmetric distributions.";
    }

    public void setPropertyBridgeSelectionStrategy(StringArrayWrapper saw) {
        this.bridgeSelectionStrategy = saw.getIndex();
    }

    public StringArrayWrapper getPropertyBridgeSelectionStrategy() {
        String[] s = new String[]{"Random", "Evenly distributed", "Stairs"};
        return new StringArrayWrapper(s, this.bridgeSelectionStrategy);
    }

    public String getShortDescriptionForBridgeSelectionStrategy() {
        return "Bridge selection strategy";
    }

    public String getLongDescriptionForBridgeSelectionStrategy() {
        return "The strategy used to select the bridges. Choose random distribution or evenly distributed edges. Stairs is a special bridge distribution for two cliques only.";
    }

    public int[][] getBridges() {
        return this.bridges;
    }

    public Clique[] getCliques() {
        return this.cliques;
    }

    public class Clique
    implements Serializable {
        int size;
        int start;

        Clique(int start, int size) {
            this.start = start;
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public int getStart() {
            return this.start;
        }
    }
}

