/*
 * Decompiled with CFR 0.152.
 */
package freak.core.modulesupport;

import freak.core.modulesupport.ClassPersistenceHandler;
import freak.core.modulesupport.PersistenceManager;
import freak.core.modulesupport.PropertyManager;
import freak.core.modulesupport.XMLizeException;
import java.io.Serializable;
import java.util.HashMap;
import org.jdom.Element;

public class Configuration
implements Serializable {
    protected HashMap simpleConfigs = new HashMap();
    protected Object additional;
    protected String descriptionOfAdditional = "";

    public void setAdditional(Object o, String descr) {
        this.additional = o;
        this.descriptionOfAdditional = descr;
    }

    public Object getAdditional() {
        return this.additional;
    }

    public static Configuration getConfigurationFor(Object obj, Configuration putTo) {
        String[] propNames = PropertyManager.getListOfPropertyNames(obj);
        int i = 0;
        while (i < propNames.length) {
            PropertyWrapper wrp = new PropertyWrapper();
            try {
                wrp.value = PropertyManager.getProperty(obj, propNames[i]);
                wrp.shortDescription = PropertyManager.getShortDescriptionFor(obj, propNames[i]);
                putTo.simpleConfigs.put(propNames[i], wrp);
            }
            catch (UnsupportedOperationException e) {
                String[] pNamesNew = new String[propNames.length - 1];
                if (i > 0) {
                    System.arraycopy(propNames, 0, pNamesNew, 0, i);
                }
                System.arraycopy(propNames, i + 1, pNamesNew, i, propNames.length - i - 1);
                propNames = pNamesNew;
                --i;
            }
            ++i;
        }
        return putTo;
    }

    public static Configuration getConfigurationFor(Object obj) {
        return Configuration.getConfigurationFor(obj, new Configuration());
    }

    public static void setConfigurationFor(Object obj, Configuration conf) {
        if (conf == null) {
            return;
        }
        Object[] tmp = conf.simpleConfigs.keySet().toArray();
        int i = 0;
        while (i < tmp.length && tmp[i] != null) {
            ++i;
        }
        int size = i;
        String[] names = new String[size];
        i = 0;
        while (i < size) {
            names[i] = (String)tmp[i];
            ++i;
        }
        i = 0;
        while (i < size) {
            PropertyManager.setProperty(obj, names[i], ((PropertyWrapper)conf.simpleConfigs.get((Object)names[i])).value);
            ++i;
        }
    }

    public String getDescription() {
        Object[] tmp = this.simpleConfigs.keySet().toArray();
        int i = 0;
        while (i < tmp.length && tmp[i] != null) {
            ++i;
        }
        int size = i;
        String[] pNames = new String[size];
        i = 0;
        while (i < size) {
            pNames[i] = (String)tmp[i];
            ++i;
        }
        StringBuffer out = new StringBuffer();
        i = 0;
        while (i < pNames.length) {
            Object val = ((PropertyWrapper)this.simpleConfigs.get((Object)pNames[i])).value;
            String name = ((PropertyWrapper)this.simpleConfigs.get((Object)pNames[i])).shortDescription;
            out.append(String.valueOf(name) + "=" + (val == null ? "null" : val.toString()));
            if (i != pNames.length - 1) {
                out.append(",");
            }
            ++i;
        }
        out.append(this.descriptionOfAdditional);
        return out.toString();
    }

    protected static class PropertyWrapper
    implements Serializable {
        public Object value;
        public String shortDescription;

        protected PropertyWrapper() {
        }
    }

    public static class ConfigurationPersistenceHandler
    implements ClassPersistenceHandler {
        private PersistenceManager pm = null;

        public ConfigurationPersistenceHandler(PersistenceManager pm) {
            this.pm = pm;
        }

        public Element toXML(Object o) throws XMLizeException {
            Configuration config = (Configuration)o;
            Element result = new Element("Configuration");
            result.addContent(this.pm.toXML(config.simpleConfigs));
            result.addContent(this.pm.toXML(config.additional));
            result.setAttribute("descriptionOfAdditional", config.descriptionOfAdditional);
            return result;
        }

        public Object fromXML(Element e) throws XMLizeException {
            Configuration result = new Configuration();
            result.simpleConfigs = (HashMap)this.pm.fromXML((Element)e.getChildren().get(0));
            result.additional = e.getChildren().get(1);
            result.descriptionOfAdditional = e.getAttributeValue("descriptionOfAdditional");
            return result;
        }

        public Class handles() {
            return Configuration.class;
        }
    }

    public static class PropertyWrapperPersistenceHandler
    implements ClassPersistenceHandler {
        private PersistenceManager pm = null;

        public PropertyWrapperPersistenceHandler(PersistenceManager pm) {
            this.pm = pm;
        }

        public Element toXML(Object o) throws XMLizeException {
            PropertyWrapper pw = (PropertyWrapper)o;
            Element result = new Element("Property");
            result.addContent(this.pm.toXML(pw.value));
            result.setAttribute("description", pw.shortDescription);
            return result;
        }

        public Object fromXML(Element e) throws XMLizeException {
            PropertyWrapper result = new PropertyWrapper();
            result.value = this.pm.fromXML((Element)e.getChildren().get(0));
            result.shortDescription = e.getAttribute("description").getValue();
            return result;
        }

        public Class handles() {
            return PropertyWrapper.class;
        }
    }
}

