/*
 * Decompiled with CFR 0.152.
 */
package freak.core.graph;

import freak.core.control.Schedule;
import freak.core.graph.AbstractVariation;
import freak.core.graph.GraphException;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.IncompatibleModuleException;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.core.searchspace.SearchSpace;
import java.util.Iterator;

public abstract class Mutation
extends AbstractVariation {
    public Mutation(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addOutPort();
    }

    protected abstract Individual doMutation(Individual var1);

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        IndividualList[] output = new IndividualList[]{new Population(this.graph.getSchedule(), input[0].size())};
        Iterator it = input[0].iterator();
        while (it.hasNext()) {
            output[0].addIndividual(this.doMutation((Individual)it.next()));
        }
        return output;
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchSpace = schedule.getGenotypeSearchSpace();
        String searchSpaceName = searchSpace.getClass().getName().toLowerCase();
        searchSpaceName = searchSpaceName.substring(searchSpaceName.lastIndexOf(46) + 1, searchSpaceName.length());
        String packageName = this.getClass().getPackage().getName();
        if (!packageName.endsWith(searchSpaceName) && !packageName.endsWith("common")) {
            throw new IncompatibleModuleException(schedule.getGenotypeSearchSpace(), "Wrong search space.");
        }
    }
}

