/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class VertexRenderer
extends JLabel
implements CellViewRenderer,
Serializable {
    protected boolean hideGroups = true;
    protected transient JGraph graph;
    protected transient VertexView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient boolean childrenSelected;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color bordercolor;
    protected transient int borderWidth;
    transient boolean isDoubleBuffered = false;

    public VertexRenderer() {
    }

    public VertexRenderer(boolean bl) {
        this.hideGroups = bl;
    }

    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        this.graph = jGraph;
        this.isDoubleBuffered = jGraph.isDoubleBuffered();
        if (cellView instanceof VertexView) {
            this.view = (VertexView)cellView;
            this.setComponentOrientation(jGraph.getComponentOrientation());
            if (jGraph.getEditingCell() != cellView.getCell()) {
                String string = jGraph.convertValueToString(cellView);
                if (string != null) {
                    this.setText(string.toString());
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
            this.graph = jGraph;
            this.hasFocus = bl2;
            this.childrenSelected = jGraph.getSelectionModel().isChildrenSelected(cellView.getCell());
            this.selected = bl;
            this.preview = bl3;
            if (this.view.isLeaf() || !this.hideGroups) {
                this.installAttributes(cellView);
            } else {
                this.setText(null);
                this.setBorder(null);
                this.setOpaque(false);
                this.setIcon(null);
            }
            return this;
        }
        return null;
    }

    protected void installAttributes(CellView cellView) {
        Color color;
        Map map = cellView.getAllAttributes();
        this.setIcon(GraphConstants.getIcon(map));
        this.setOpaque(GraphConstants.isOpaque(map));
        this.setBorder(GraphConstants.getBorder(map));
        this.setVerticalAlignment(GraphConstants.getVerticalAlignment(map));
        this.setHorizontalAlignment(GraphConstants.getHorizontalAlignment(map));
        this.setVerticalTextPosition(GraphConstants.getVerticalTextPosition(map));
        this.setHorizontalTextPosition(GraphConstants.getHorizontalTextPosition(map));
        this.bordercolor = GraphConstants.getBorderColor(map);
        this.borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((color = GraphConstants.getForeground(map)) != null ? color : this.defaultForeground);
        Color color2 = GraphConstants.getBackground(map);
        this.setBackground(color2 != null ? color2 : this.defaultBackground);
        this.setFont(GraphConstants.getFont(map));
    }

    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            this.paintSelectionBorder(graphics);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected void paintSelectionBorder(Graphics graphics) {
        ((Graphics2D)graphics).setStroke(GraphConstants.SELECTION_STROKE);
        if (this.childrenSelected) {
            graphics.setColor(this.graph.getGridColor());
        } else if (this.hasFocus && this.selected) {
            graphics.setColor(this.graph.getLockedHandleColor());
        } else if (this.selected) {
            graphics.setColor(this.graph.getHighlightColor());
        }
        if (this.childrenSelected || this.selected) {
            Dimension dimension = this.getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public Point getPerimeterPoint(VertexView vertexView, Point point, Point point2) {
        Rectangle rectangle = vertexView.getBounds();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = n + n3 / 2;
        int n6 = n2 + n4 / 2;
        int n7 = point2.x - n5;
        int n8 = point2.y - n6;
        double d = Math.atan2(n8, n7);
        int n9 = 0;
        int n10 = 0;
        double d2 = Math.PI;
        double d3 = 1.5707963267948966;
        double d4 = d3 - d;
        double d5 = Math.atan2(n4, n3);
        if (d < -d2 + d5 || d > d2 - d5) {
            n9 = n;
            n10 = n6 - (int)((double)n3 * Math.tan(d) / 2.0);
        } else if (d < -d5) {
            n10 = n2;
            n9 = n5 - (int)((double)n4 * Math.tan(d4) / 2.0);
        } else if (d < d5) {
            n9 = n + n3;
            n10 = n6 + (int)((double)n3 * Math.tan(d) / 2.0);
        } else {
            n10 = n2 + n4;
            n9 = n5 + (int)((double)n4 * Math.tan(d4) / 2.0);
        }
        return new Point(n9, n10);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public boolean isHideGroups() {
        return this.hideGroups;
    }

    public void setHideGroups(boolean bl) {
        this.hideGroups = bl;
    }
}

